/*
 * Decompiled with CFR 0.152.
 */
package me.z609.pointsapi2.player;

import java.util.HashMap;
import java.util.Map;
import me.z609.pointsapi2.currency.Currency;
import me.z609.pointsapi2.player.OfflinePointsPlayer;
import me.z609.pointsapi2.player.PointsPlayerManager;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class PointsPlayer
extends OfflinePointsPlayer {
    private Player bukkitPlayer;
    private Map<Currency, Integer> currencyValues = new HashMap<Currency, Integer>();

    public PointsPlayer(PointsPlayerManager parent, Player bukkitPlayer) {
        super(parent, bukkitPlayer.getUniqueId());
        this.bukkitPlayer = bukkitPlayer;
        FileConfiguration configuration = parent.getParent().getConfig();
        for (int i = 0; i < parent.getParent().getCurrencyManager().getCurrencies().size(); ++i) {
            Currency currency = parent.getParent().getCurrencyManager().getCurrencies().get(i);
            try {
                int value = configuration.getInt("values." + this.getUniqueId().toString() + "." + currency.getId());
                this.currencyValues.put(currency, value);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getName() {
        return this.bukkitPlayer.getName();
    }

    @Override
    public void set(Currency currency, int value) {
        if (this.currencyValues.containsKey(currency)) {
            this.currencyValues.remove(currency);
        }
        this.currencyValues.put(currency, value);
    }

    @Override
    public int get(Currency currency) {
        if (!this.currencyValues.containsKey(currency)) {
            this.currencyValues.put(currency, currency.getDefaultValue());
        }
        return this.currencyValues.get(currency);
    }

    public void save() {
        for (Map.Entry<Currency, Integer> entry : this.currencyValues.entrySet()) {
            Currency currency = entry.getKey();
            int value = entry.getValue();
            this.parent.getParent().getConfig().set("values." + this.getUniqueId().toString() + "." + currency.getId(), (Object)value);
            this.parent.getParent().save();
        }
    }

    public Player getBukkitPlayer() {
        return this.bukkitPlayer;
    }

    public Map<Currency, Integer> getCurrencyValues() {
        return this.currencyValues;
    }
}

