/*
 * Decompiled with CFR 0.152.
 */
package me.z609.pointsapi2.currency;

import java.util.ArrayList;
import java.util.List;
import me.z609.pointsapi2.PointsAPI;
import me.z609.pointsapi2.currency.Currency;
import org.bukkit.configuration.file.FileConfiguration;

public class CurrencyManager {
    private PointsAPI parent;
    private List<Currency> currencies = new ArrayList<Currency>();

    public CurrencyManager(PointsAPI parent) {
        this.parent = parent;
        FileConfiguration configuration = parent.getConfig();
        for (String s : configuration.getConfigurationSection("currencies").getKeys(false)) {
            String key = "currencies." + s + ".";
            String singular = configuration.getString(key + "singular");
            String plural = configuration.getString(key + "plural");
            int defaultValue = configuration.getInt(key + "defaultValue");
            Currency currency = new Currency(this, s, singular, plural, defaultValue);
            this.currencies.add(currency);
        }
    }

    public Currency getCurrency(String name) {
        for (Currency currency : this.currencies) {
            if (!currency.getId().equalsIgnoreCase(name)) continue;
            return currency;
        }
        return null;
    }

    public PointsAPI getParent() {
        return this.parent;
    }

    public List<Currency> getCurrencies() {
        return this.currencies;
    }
}

