/*
 * Decompiled with CFR 0.152.
 */
package me.z609.pointsapi2.command;

import java.util.Map;
import java.util.UUID;
import me.z609.pointsapi2.PointsAPI;
import me.z609.pointsapi2.StaticPointsAPI;
import me.z609.pointsapi2.currency.Currency;
import me.z609.pointsapi2.player.OfflinePointsPlayer;
import me.z609.pointsapi2.player.PointsPlayer;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PointsCommand
implements CommandExecutor {
    private PointsAPI parent;

    public PointsCommand(PointsAPI parent) {
        this.parent = parent;
        parent.getCommand("points").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("points")) {
            if (sender.hasPermission("points.*") || sender.hasPermission("points.points")) {
                if (args.length == 0) {
                    sender.sendMessage("\u00a7b\u00a7lPointsAPI \u00a7eby Z609");
                    sender.sendMessage("\u00a7b/points set <username> <currency> <amount> - Set points");
                    sender.sendMessage("\u00a7b/points add|give <username> <currency> <amount> - Add points");
                    sender.sendMessage("\u00a7b/points deduct|take <username> <currency> <amount> - Deduct points");
                    sender.sendMessage("\u00a7b/points reset <username> <currency> - Reset points");
                    sender.sendMessage("\u00a7b/points balance - See your points (admin version)");
                    sender.sendMessage("\u00a7b/balance|bal|money - User-friendly /balance");
                } else if (args[0].equalsIgnoreCase("balance")) {
                    if (args.length == 1 && sender instanceof Player) {
                        PointsPlayer player = this.parent.getPointsPlayerManager().getPlayer((Player)sender);
                        for (Map.Entry<Currency, Integer> balance : player.getCurrencyValues().entrySet()) {
                            sender.sendMessage("\u00a7bYou have " + balance.getValue() + " " + (balance.getValue() != 1 ? balance.getKey().getNamePlural() : balance.getKey().getNameSingular()) + "!");
                        }
                    }
                } else if (args[0].equalsIgnoreCase("set")) {
                    if (args.length < 4) {
                        sender.sendMessage("\u00a7cPlease specify a username, currency, and an amount!");
                    } else {
                        String targetRaw = args[1];
                        String currencyRaw = args[2];
                        String iRaw = args[3];
                        this.update(sender, targetRaw, currencyRaw, CmdPointType.SET, iRaw);
                    }
                } else if (args[0].equalsIgnoreCase("add") || args[0].equalsIgnoreCase("give")) {
                    if (args.length < 4) {
                        sender.sendMessage("\u00a7cPlease specify a username, currency, and an amount!");
                    } else {
                        String targetRaw = args[1];
                        String currencyRaw = args[2];
                        String iRaw = args[3];
                        this.update(sender, targetRaw, currencyRaw, CmdPointType.ADD, iRaw);
                    }
                } else if (args[0].equalsIgnoreCase("deduct") || args[0].equalsIgnoreCase("take")) {
                    if (args.length < 4) {
                        sender.sendMessage("\u00a7cPlease specify a username, currency, and an amount!");
                    } else {
                        String targetRaw = args[1];
                        String currencyRaw = args[2];
                        String iRaw = args[3];
                        this.update(sender, targetRaw, currencyRaw, CmdPointType.DEDUCT, iRaw);
                    }
                } else if (args[0].equalsIgnoreCase("reset")) {
                    if (args.length < 3) {
                        sender.sendMessage("\u00a7cPlease specify a username and an amount!");
                    } else {
                        String targetRaw = args[1];
                        String currencyRaw = args[2];
                        this.update(sender, targetRaw, currencyRaw, CmdPointType.RESET, "0");
                    }
                }
            } else {
                sender.sendMessage("Insufficient privileges.");
            }
        }
        return true;
    }

    public void update(CommandSender sender, String name, String strcurrency, CmdPointType type, String strint) {
        if (this.parent.getCurrencyManager().getCurrency(strcurrency) == null) {
            sender.sendMessage("\u00a7cInvalid currency!");
            return;
        }
        Currency currency = this.parent.getCurrencyManager().getCurrency(strcurrency);
        if (StaticPointsAPI.isInteger(strint)) {
            int i = Integer.parseInt(strint);
            UUID uuid = Bukkit.getServer().getOfflinePlayer(name).getUniqueId();
            if (uuid != null) {
                if (Bukkit.getPlayerExact((String)name) != null) {
                    PointsPlayer pointsPlayer = this.parent.getPointsPlayerManager().getPlayer(Bukkit.getPlayerExact((String)name));
                    if (type == CmdPointType.ADD) {
                        pointsPlayer.set(currency, pointsPlayer.get(currency) + i);
                    } else if (type == CmdPointType.DEDUCT) {
                        pointsPlayer.set(currency, pointsPlayer.get(currency) - i);
                    } else if (type == CmdPointType.SET) {
                        pointsPlayer.set(currency, i);
                    } else if (type == CmdPointType.RESET) {
                        pointsPlayer.set(currency, pointsPlayer.get(currency) + i);
                    }
                    Bukkit.getPlayerExact((String)name).sendMessage("\u00a7bYour balance was updated.");
                } else {
                    OfflinePointsPlayer pointsPlayer = this.parent.getPointsPlayerManager().getOfflinePlayer(uuid);
                    if (type == CmdPointType.ADD) {
                        pointsPlayer.set(currency, pointsPlayer.get(currency) + i);
                    } else if (type == CmdPointType.DEDUCT) {
                        pointsPlayer.set(currency, pointsPlayer.get(currency) - i);
                    } else if (type == CmdPointType.SET) {
                        pointsPlayer.set(currency, i);
                    } else if (type == CmdPointType.RESET) {
                        pointsPlayer.set(currency, pointsPlayer.get(currency) + i);
                    }
                    sender.sendMessage("\u00a7bYou have updated " + name + "'s account balance.");
                }
            } else {
                sender.sendMessage("\u00a7cThat player name is not a valid Minecraft username!");
            }
        } else {
            sender.sendMessage("\u00a7cThat is not a number!");
        }
    }

    public static enum CmdPointType {
        SET,
        DEDUCT,
        RESET,
        ADD;

    }
}

