/*
 * Decompiled with CFR 0.152.
 */
package me.z609.pointsapi2;

import java.util.logging.Level;
import me.z609.pointsapi2.command.PointsCommand;
import me.z609.pointsapi2.currency.CurrencyManager;
import me.z609.pointsapi2.player.ChatFormatterListener;
import me.z609.pointsapi2.player.PointsPlayer;
import me.z609.pointsapi2.player.PointsPlayerManager;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PointsAPI
extends JavaPlugin {
    private CurrencyManager currencyManager;
    private PointsPlayerManager pointsPlayerManager;
    private boolean fullInit = false;

    public void onEnable() {
        if (this.getServer().getPluginManager().isPluginEnabled("ChatFormatter")) {
            this.getServer().getLogger().log(Level.INFO, "Dependency ChatFormatter was found...enabling!");
            this.getServer().getPluginManager().registerEvents((Listener)new ChatFormatterListener(this), (Plugin)this);
        }
        this.getConfig().options().copyDefaults(true);
        this.save();
        this.currencyManager = new CurrencyManager(this);
        this.pointsPlayerManager = new PointsPlayerManager(this);
        new PointsCommand(this);
        this.fullInit = true;
    }

    public void onDisable() {
        if (!this.fullInit) {
            return;
        }
        for (PointsPlayer player : this.pointsPlayerManager.getPlayers()) {
            player.save();
        }
    }

    public void reload() {
        this.reloadConfig();
    }

    public void save() {
        this.saveConfig();
        this.reload();
    }

    public CurrencyManager getCurrencyManager() {
        return this.currencyManager;
    }

    public PointsPlayerManager getPointsPlayerManager() {
        return this.pointsPlayerManager;
    }
}

