/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.version;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import net.achymake.players.Players;
import net.achymake.players.files.Message;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private final Players plugin;
    private final int resourceId;

    public UpdateChecker(Players plugin, int resourceId) {
        this.plugin = plugin;
        this.resourceId = resourceId;
    }

    public void getVersion(Consumer<String> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openStream();
                Scanner scanner = new Scanner(inputStream);
                if (scanner.hasNext()) {
                    consumer.accept(scanner.next());
                    scanner.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                Message.sendLog(e.getMessage());
            }
        });
    }

    public void getUpdate() {
        if (this.plugin.getConfig().getBoolean("notify-update.enable")) {
            new UpdateChecker(this.plugin, this.resourceId).getVersion(latest -> {
                if (this.plugin.getDescription().getVersion().equalsIgnoreCase((String)latest)) {
                    Message.sendLog("You are using the latest version");
                } else {
                    Message.sendLog("New update: " + latest);
                    Message.sendLog("Current version: " + this.plugin.getDescription().getVersion());
                }
            });
        }
    }

    public void sendMessage(Player player) {
        if (Players.getInstance().getConfig().getBoolean("notify-update.enable")) {
            new UpdateChecker(Players.getInstance(), this.resourceId).getVersion(latest -> {
                if (!Players.getInstance().getDescription().getVersion().equalsIgnoreCase((String)latest)) {
                    Message.sendMessage(player, "&6" + Players.getInstance().getName() + " Update:");
                    Message.sendMessage(player, "&6new release: &f" + latest);
                    Message.sendMessage(player, "&6current: &f" + Players.getInstance().getDescription().getVersion());
                }
            });
        }
    }
}

