/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.listeners.respawn;

import net.achymake.players.Players;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class PlayerRespawn
implements Listener {
    public PlayerRespawn(Players plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerRespawnEvent(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!PlayerConfig.get((OfflinePlayer)player).getBoolean("dead")) {
            return;
        }
        if (player.hasPermission("players.show-death-location")) {
            Message.sendMessage(player, "&6Death location:");
            String worldName = PlayerConfig.get((OfflinePlayer)player).getString("death-location.world");
            double x = PlayerConfig.get((OfflinePlayer)player).getDouble("death-location.x");
            double y = PlayerConfig.get((OfflinePlayer)player).getDouble("death-location.y");
            double z = PlayerConfig.get((OfflinePlayer)player).getDouble("death-location.z");
            float yaw = PlayerConfig.get((OfflinePlayer)player).getLong("death-location.yaw");
            float pitch = PlayerConfig.get((OfflinePlayer)player).getLong("death-location.pitch");
            Location location = new Location(Players.getInstance().getServer().getWorld(worldName), x, y, z, yaw, pitch);
            Message.sendMessage(player, "&6World:&f " + location.getWorld().getEnvironment().name().toLowerCase() + " &6X:&f " + location.getBlockX() + " &6Y:&f " + location.getBlockY() + " &6Z:&f " + location.getBlockZ());
        }
        if (player.hasPermission("players.command.back.death")) {
            Message.sendMessage(player, "&6You can use&a /back&6 to teleport back");
        }
        PlayerConfig.setString((OfflinePlayer)player, "dead", null);
    }
}

