/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.listeners.chat;

import java.text.MessageFormat;
import me.clip.placeholderapi.PlaceholderAPI;
import net.achymake.players.Players;
import net.achymake.players.files.Config;
import net.achymake.players.files.Message;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class PlayerChat
implements Listener {
    public PlayerChat(Players plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChatEvent(AsyncPlayerChatEvent event) {
        if (!Config.get().getBoolean("chat.enable")) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasPermission("players.chatcolor.chat")) {
            event.setFormat(MessageFormat.format(Message.color(Config.get().getString("chat.format") + " " + event.getMessage()), this.prefix(player), this.name(player), this.suffix(player)));
        } else {
            event.setFormat(MessageFormat.format(Message.color(Config.get().getString("chat.format")) + " " + event.getMessage(), this.prefix(player), this.name(player), this.suffix(player)));
        }
    }

    private String prefix(Player player) {
        if (PlaceholderAPI.isRegistered((String)"vault")) {
            return Message.color("&f" + PlaceholderAPI.setPlaceholders((Player)player, (String)"%vault_prefix%") + "&f");
        }
        return "";
    }

    private String name(Player player) {
        if (PlaceholderAPI.isRegistered((String)"players")) {
            return Message.color("&f" + PlaceholderAPI.setPlaceholders((Player)player, (String)"%players_name%") + "&f");
        }
        return Message.color("&f" + player.getName() + "&f");
    }

    private String suffix(Player player) {
        if (PlaceholderAPI.isRegistered((String)"vault")) {
            return Message.color("&f" + PlaceholderAPI.setPlaceholders((Player)player, (String)"%vault_suffix%") + "&f");
        }
        return "";
    }
}

