/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.files;

import java.io.File;
import java.io.IOException;
import net.achymake.players.Players;
import net.achymake.players.files.Message;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class WarpsConfig {
    private static File file = new File(Players.getInstance().getDataFolder(), "warps.yml");
    private static FileConfiguration config = YamlConfiguration.loadConfiguration((File)file);

    public static FileConfiguration get() {
        return config;
    }

    public static void setup() {
        WarpsConfig.get().options().copyDefaults(true);
        WarpsConfig.save();
    }

    public static void setWarp(Player player, String warpName) {
        WarpsConfig.get().set(warpName + ".world", (Object)player.getLocation().getWorld().getName());
        WarpsConfig.get().set(warpName + ".x", (Object)player.getLocation().getX());
        WarpsConfig.get().set(warpName + ".y", (Object)player.getLocation().getY());
        WarpsConfig.get().set(warpName + ".z", (Object)player.getLocation().getZ());
        WarpsConfig.get().set(warpName + ".yaw", (Object)Float.valueOf(player.getLocation().getYaw()));
        WarpsConfig.get().set(warpName + ".pitch", (Object)Float.valueOf(player.getLocation().getPitch()));
        WarpsConfig.save();
    }

    public static Location getWarp(String warpName) {
        String worldName = WarpsConfig.get().getString(warpName + ".world");
        double x = WarpsConfig.get().getDouble(warpName + ".x");
        double y = WarpsConfig.get().getDouble(warpName + ".y");
        double z = WarpsConfig.get().getDouble(warpName + ".z");
        float yaw = WarpsConfig.get().getLong(warpName + ".yaw");
        float pitch = WarpsConfig.get().getLong(warpName + ".pitch");
        return new Location(Players.getInstance().getServer().getWorld(worldName), x, y, z, yaw, pitch);
    }

    public static void save() {
        try {
            WarpsConfig.get().save(file);
        }
        catch (IOException e) {
            Message.sendLog(e.getMessage());
        }
    }

    public static void reload() {
        config = YamlConfiguration.loadConfiguration((File)file);
    }
}

