/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.files;

import java.io.File;
import java.io.IOException;
import net.achymake.players.Players;
import net.achymake.players.files.Message;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class SpawnConfig {
    private static File file = new File(Players.getInstance().getDataFolder(), "spawn.yml");
    private static FileConfiguration config = YamlConfiguration.loadConfiguration((File)file);

    public static FileConfiguration get() {
        return config;
    }

    public static void setup() {
        SpawnConfig.get().options().copyDefaults(true);
        SpawnConfig.save();
    }

    public static void setSpawn(Location location) {
        SpawnConfig.get().set("spawn.world", (Object)location.getWorld().getName());
        SpawnConfig.get().set("spawn.x", (Object)location.getX());
        SpawnConfig.get().set("spawn.y", (Object)location.getY());
        SpawnConfig.get().set("spawn.z", (Object)location.getZ());
        SpawnConfig.get().set("spawn.yaw", (Object)Float.valueOf(location.getYaw()));
        SpawnConfig.get().set("spawn.pitch", (Object)Float.valueOf(location.getPitch()));
        SpawnConfig.save();
    }

    public static Location getSpawn() {
        String worldName = SpawnConfig.get().getString("spawn.world");
        double x = SpawnConfig.get().getDouble("spawn.x");
        double y = SpawnConfig.get().getDouble("spawn.y");
        double z = SpawnConfig.get().getDouble("spawn.z");
        float yaw = SpawnConfig.get().getLong("spawn.yaw");
        float pitch = SpawnConfig.get().getLong("spawn.pitch");
        return new Location(Players.getInstance().getServer().getWorld(worldName), x, y, z, yaw, pitch);
    }

    public static void save() {
        try {
            SpawnConfig.get().save(file);
        }
        catch (IOException e) {
            Message.sendLog(e.getMessage());
        }
    }

    public static void reload() {
        config = YamlConfiguration.loadConfiguration((File)file);
    }
}

