/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.files;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import net.achymake.players.Players;
import net.achymake.players.files.Config;
import net.achymake.players.files.Message;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerConfig {
    public static boolean exist(OfflinePlayer offlinePlayer) {
        return new File(Players.getInstance().getDataFolder(), "userdata/" + offlinePlayer.getUniqueId() + ".yml").exists();
    }

    public static void create(OfflinePlayer offlinePlayer) {
        File folder = new File(Players.getInstance().getDataFolder(), "userdata");
        File file = new File(Players.getInstance().getDataFolder(), "userdata/" + offlinePlayer.getUniqueId() + ".yml");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (file.exists()) {
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
            if (!configuration.getString("name").equals(offlinePlayer.getName())) {
                configuration.set("name", (Object)offlinePlayer.getName());
                try {
                    configuration.save(file);
                }
                catch (IOException e) {
                    Message.sendLog(e.getMessage());
                }
            }
        } else {
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
            configuration.set("name", (Object)offlinePlayer.getName());
            configuration.set("custom-name", (Object)offlinePlayer.getName());
            new Config();
            configuration.set("account", (Object)Config.get().getDouble("economy.starting-balance"));
            new Config();
            configuration.set("points", (Object)Config.get().getDouble("points.starting-points"));
            new Config();
            configuration.set("max-homes", (Object)Config.get().getInt("homes.default"));
            configuration.set("pvp", (Object)true);
            configuration.createSection("homes");
            try {
                configuration.save(file);
            }
            catch (IOException e) {
                Message.sendLog(e.getMessage());
            }
        }
    }

    public static FileConfiguration get(OfflinePlayer offlinePlayer) {
        File file = new File(Players.getInstance().getDataFolder(), "userdata/" + offlinePlayer.getUniqueId() + ".yml");
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public static void setVanish(Player player, boolean vanish) {
        if (vanish) {
            PlayerConfig.setBoolean((OfflinePlayer)player, "vanished", true);
            Players.getInstance().getVanished().add(player);
            for (Player players : player.getServer().getOnlinePlayers()) {
                players.hidePlayer(player);
            }
            player.setAllowFlight(true);
            player.setCollidable(false);
            player.setInvulnerable(true);
            player.setCanPickupItems(false);
            player.setSleepingIgnored(true);
            player.setSilent(true);
            for (Player vanishedPlayers : Players.getInstance().getVanished()) {
                vanishedPlayers.showPlayer(player);
                player.showPlayer(vanishedPlayers);
            }
        } else {
            PlayerConfig.setBoolean((OfflinePlayer)player, "vanished", false);
            Players.getInstance().getVanished().remove(player);
            for (Player players : player.getServer().getOnlinePlayers()) {
                players.showPlayer(player);
            }
            player.setCollidable(true);
            player.setInvulnerable(false);
            player.setCanPickupItems(true);
            player.setSleepingIgnored(false);
            player.setSilent(false);
            for (Player vanishedPlayers : Players.getInstance().getVanished()) {
                player.hidePlayer(vanishedPlayers);
            }
        }
    }

    public static void setBoolean(OfflinePlayer offlinePlayer, String type, boolean value) {
        File file = new File(Players.getInstance().getDataFolder(), "userdata/" + offlinePlayer.getUniqueId() + ".yml");
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        if (type.equals("vanished")) {
            // empty if block
        }
        if (value) {
            configuration.set(type, (Object)true);
        } else {
            configuration.set(type, (Object)false);
        }
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            Message.sendLog(e.getMessage());
        }
    }

    public static void setString(OfflinePlayer offlinePlayer, String type, String value) {
        File file = new File(Players.getInstance().getDataFolder(), "userdata/" + offlinePlayer.getUniqueId() + ".yml");
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        configuration.set(type, (Object)value);
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            Message.sendLog(e.getMessage());
        }
    }

    public static void setStringList(OfflinePlayer offlinePlayer, String type, List<String> value) {
        File file = new File(Players.getInstance().getDataFolder(), "userdata/" + offlinePlayer.getUniqueId() + ".yml");
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        configuration.set(type, value);
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            Message.sendLog(e.getMessage());
        }
    }

    public static void setUUIDList(OfflinePlayer offlinePlayer, String type, List<UUID> value) {
        File file = new File(Players.getInstance().getDataFolder(), "userdata/" + offlinePlayer.getUniqueId() + ".yml");
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        configuration.set(type, value);
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            Message.sendLog(e.getMessage());
        }
    }

    public static void setInt(OfflinePlayer offlinePlayer, String type, int value) {
        File file = new File(Players.getInstance().getDataFolder(), "userdata/" + offlinePlayer.getUniqueId() + ".yml");
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        int amount = configuration.getInt(type) + value;
        configuration.set(type, (Object)amount);
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            Message.sendLog(e.getMessage());
        }
    }

    public static void setDouble(OfflinePlayer offlinePlayer, String type, double value) {
        File file = new File(Players.getInstance().getDataFolder(), "userdata/" + offlinePlayer.getUniqueId() + ".yml");
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        configuration.set(type, (Object)value);
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            Message.sendLog(e.getMessage());
        }
    }

    public static void setFloat(OfflinePlayer offlinePlayer, String type, float value) {
        File file = new File(Players.getInstance().getDataFolder(), "userdata/" + offlinePlayer.getUniqueId() + ".yml");
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
        configuration.set(type, (Object)Float.valueOf(value));
        try {
            configuration.save(file);
        }
        catch (IOException e) {
            Message.sendLog(e.getMessage());
        }
    }

    public static void setLocation(Player player, String locationName) {
        Location location = player.getLocation();
        PlayerConfig.setString((OfflinePlayer)player, locationName + ".world", location.getWorld().getName());
        PlayerConfig.setDouble((OfflinePlayer)player, locationName + ".x", location.getX());
        PlayerConfig.setDouble((OfflinePlayer)player, locationName + ".y", location.getY());
        PlayerConfig.setDouble((OfflinePlayer)player, locationName + ".z", location.getZ());
        PlayerConfig.setFloat((OfflinePlayer)player, locationName + ".yaw", location.getYaw());
        PlayerConfig.setFloat((OfflinePlayer)player, locationName + ".pitch", location.getPitch());
    }

    public static Location getLocation(OfflinePlayer offlinePlayer, String locationName) {
        String worldName = PlayerConfig.get(offlinePlayer).getString(locationName + ".world");
        double x = PlayerConfig.get(offlinePlayer).getDouble(locationName + ".x");
        double y = PlayerConfig.get(offlinePlayer).getDouble(locationName + ".y");
        double z = PlayerConfig.get(offlinePlayer).getDouble(locationName + ".z");
        float yaw = PlayerConfig.get(offlinePlayer).getLong(locationName + ".yaw");
        float pitch = PlayerConfig.get(offlinePlayer).getLong(locationName + ".pitch");
        return new Location(Players.getInstance().getServer().getWorld(worldName), x, y, z, yaw, pitch);
    }
}

