/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.files;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import net.achymake.players.Players;
import net.achymake.players.files.Message;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MotdConfig {
    private static File file = new File(Players.getInstance().getDataFolder(), "motd.yml");
    private static FileConfiguration config = YamlConfiguration.loadConfiguration((File)file);

    public static FileConfiguration get() {
        return config;
    }

    public static void setup() {
        if (!file.exists()) {
            ArrayList<String> motd = new ArrayList<String>();
            motd.add("&6Message of The Day!");
            motd.add("&6You can change or create new motd");
            MotdConfig.get().addDefault("motd", motd);
            ArrayList<String> welcome = new ArrayList<String>();
            welcome.add("&6Welcome&f {0}&6 to the server!");
            welcome.add("&6Hope you enjoy your adventure!");
            MotdConfig.get().addDefault("welcome", welcome);
            ArrayList<String> welcomeBack = new ArrayList<String>();
            welcomeBack.add("&6Welcome back&f {0}&6!");
            welcomeBack.add("&6We missed you!");
            MotdConfig.get().addDefault("welcome-back", welcomeBack);
            MotdConfig.get().options().copyDefaults(true);
            MotdConfig.save();
        }
    }

    public static void sendMessages(Player player, String motd) {
        for (String messages : MotdConfig.get().getStringList(motd)) {
            Message.sendMessage(player, MessageFormat.format(messages, player.getName()));
        }
    }

    public static void save() {
        try {
            MotdConfig.get().save(file);
        }
        catch (IOException e) {
            Message.sendLog(e.getMessage());
        }
    }

    public static void reload() {
        config = YamlConfiguration.loadConfiguration((File)file);
    }
}

