/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.files;

import java.io.File;
import java.io.IOException;
import net.achymake.players.Players;
import net.achymake.players.files.Config;
import net.achymake.players.files.PlayerConfig;
import net.achymake.players.files.languages.Danish;
import net.achymake.players.files.languages.English;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class Message {
    public static boolean languageExist(String language) {
        return new File(Players.getInstance().getDataFolder(), "language/" + language + ".yml").exists();
    }

    public static FileConfiguration getLanguage(Player player) {
        if (PlayerConfig.get((OfflinePlayer)player).getKeys(false).contains("language")) {
            String language = PlayerConfig.get((OfflinePlayer)player).getString("language");
            File file = new File(Players.getInstance().getDataFolder(), "language/" + language + ".yml");
            return YamlConfiguration.loadConfiguration((File)file);
        }
        String language = Config.get().getString("language.default");
        File file = new File(Players.getInstance().getDataFolder(), "language/" + language + ".yml");
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public static FileConfiguration getLanguage() {
        String language = Config.get().getString("language.default");
        File file = new File(Players.getInstance().getDataFolder(), "language/" + language + ".yml");
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public static void setup() {
        Danish.setup();
        English.setup();
    }

    public static void sendActionBar(Player player, String message) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Message.color(message)));
    }

    public static void sendMessage(Player player, String message) {
        player.sendMessage(Message.color(message));
    }

    public static void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(Message.color(message));
    }

    public static void sendLog(String message) {
        Bukkit.getServer().getConsoleSender().sendMessage("[" + Players.getInstance().getName() + "] " + message);
    }

    public static String color(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static void reload() {
        File folder = new File(Players.getInstance().getDataFolder(), "language");
        if (folder.exists()) {
            for (String files : folder.list()) {
                File file = new File(Players.getInstance().getDataFolder(), "language/" + files);
                YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
                try {
                    configuration.load(file);
                }
                catch (IOException | InvalidConfigurationException e) {
                    Message.sendLog(e.getMessage());
                }
            }
        }
    }
}

