/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.files;

import java.io.File;
import java.io.IOException;
import net.achymake.players.Players;
import net.achymake.players.files.Message;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class JailConfig {
    private static File file = new File(Players.getInstance().getDataFolder(), "jail.yml");
    private static FileConfiguration config = YamlConfiguration.loadConfiguration((File)file);

    public static FileConfiguration get() {
        return config;
    }

    public static void setup() {
        JailConfig.get().options().copyDefaults(true);
        JailConfig.save();
    }

    public static void setJail(Location location) {
        JailConfig.get().set("jail.world", (Object)location.getWorld().getName());
        JailConfig.get().set("jail.x", (Object)location.getX());
        JailConfig.get().set("jail.y", (Object)location.getY());
        JailConfig.get().set("jail.z", (Object)location.getZ());
        JailConfig.get().set("jail.yaw", (Object)Float.valueOf(location.getYaw()));
        JailConfig.get().set("jail.pitch", (Object)Float.valueOf(location.getPitch()));
        JailConfig.save();
    }

    public static Location getJail() {
        String worldName = JailConfig.get().getString("jail.world");
        double x = JailConfig.get().getDouble("jail.x");
        double y = JailConfig.get().getDouble("jail.y");
        double z = JailConfig.get().getDouble("jail.z");
        float yaw = JailConfig.get().getLong("jail.yaw");
        float pitch = JailConfig.get().getLong("jail.pitch");
        return new Location(Players.getInstance().getServer().getWorld(worldName), x, y, z, yaw, pitch);
    }

    public static void save() {
        try {
            JailConfig.get().save(file);
        }
        catch (IOException e) {
            Message.sendLog(e.getMessage());
        }
    }

    public static void reload() {
        config = YamlConfiguration.loadConfiguration((File)file);
    }
}

