/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.whisper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class WhisperCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player && args.length > 1) {
            Player player = (Player)sender;
            Player target = player.getServer().getPlayerExact(args[0]);
            if (target == null) {
                Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("error.player.offline"), args[0]));
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 1; i < args.length; ++i) {
                    stringBuilder.append(args[i]);
                    stringBuilder.append(" ");
                }
                Message.sendMessage(player, "&7You > " + target.getName() + ": " + stringBuilder);
                Message.sendMessage(target, "&7" + player.getName() + " > You: " + stringBuilder);
                PlayerConfig.setString((OfflinePlayer)target, "last-whisper", player.getUniqueId().toString());
                player.getServer().broadcast(Message.color("&7" + player.getName() + " > " + target.getName() + ": " + stringBuilder), "players.notify.whisper");
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1) {
            for (Player players : sender.getServer().getOnlinePlayers()) {
                commands.add(players.getName());
            }
        }
        return commands;
    }
}

