/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.vanish;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class VanishCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 0) {
                if (PlayerConfig.get((OfflinePlayer)player).getBoolean("vanished")) {
                    PlayerConfig.setVanish(player, false);
                    Message.sendMessage(player, Message.getLanguage(player).getString("command.vanish.disable"));
                } else {
                    PlayerConfig.setVanish(player, true);
                    Message.sendMessage(player, Message.getLanguage(player).getString("command.vanish.enable"));
                }
            } else if (args.length == 1) {
                Player target = player.getServer().getPlayerExact(args[0]);
                if (target != null) {
                    if (target.hasPermission("players.command.vanish.exempt")) {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.vanish.exempt"), target.getName()));
                    } else if (PlayerConfig.get((OfflinePlayer)target).getBoolean("vanished")) {
                        PlayerConfig.setVanish(target, false);
                        Message.sendMessage(target, MessageFormat.format(Message.getLanguage(target).getString("command.vanish.others.disable.target"), player.getName()));
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.vanish.others.disable.sender"), target.getName()));
                    } else {
                        PlayerConfig.setVanish(target, true);
                        Message.sendMessage(target, MessageFormat.format(Message.getLanguage(target).getString("command.vanish.others.enable.target"), player.getName()));
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.vanish.others.enable.sender"), target.getName()));
                    }
                } else {
                    OfflinePlayer offlinePlayer = player.getServer().getOfflinePlayer(args[0]);
                    if (PlayerConfig.exist(offlinePlayer)) {
                        if (PlayerConfig.get(offlinePlayer).getBoolean("vanished")) {
                            PlayerConfig.setBoolean(offlinePlayer, "vanished", false);
                            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.vanish.others.disable.sender"), offlinePlayer.getName()));
                        } else {
                            PlayerConfig.setBoolean(offlinePlayer, "vanished", true);
                            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.vanish.others.enable.sender"), offlinePlayer.getName()));
                        }
                    } else {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("error.player.null"), args[0]));
                    }
                }
            }
        } else if (args.length == 1) {
            Player target = sender.getServer().getPlayerExact(args[0]);
            if (target != null) {
                if (PlayerConfig.get((OfflinePlayer)target).getBoolean("vanished")) {
                    PlayerConfig.setVanish(target, false);
                    Message.sendMessage(target, MessageFormat.format(Message.getLanguage(target).getString("command.vanish.others.disable.target"), sender.getName()));
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.vanish.others.disable.sender"), target.getName()));
                } else {
                    PlayerConfig.setVanish(target, true);
                    Message.sendMessage(target, MessageFormat.format(Message.getLanguage(target).getString("command.vanish.others.enable.target"), sender.getName()));
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.vanish.others.enable.sender"), target.getName()));
                }
            } else {
                OfflinePlayer offlinePlayer = sender.getServer().getOfflinePlayer(args[0]);
                if (PlayerConfig.exist(offlinePlayer)) {
                    if (PlayerConfig.get(offlinePlayer).getBoolean("vanished")) {
                        PlayerConfig.setBoolean(offlinePlayer, "vanished", false);
                        Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.vanish.others.disable.sender"), target.getName()));
                    } else {
                        PlayerConfig.setBoolean(offlinePlayer, "vanished", true);
                        Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.vanish.others.enable.sender"), target.getName()));
                    }
                } else {
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("error.player.null"), args[0]));
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1) {
            for (Player players : sender.getServer().getOnlinePlayers()) {
                commands.add(players.getName());
            }
        }
        return commands;
    }
}

