/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.tpa;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.achymake.players.Players;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TPACommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player && args.length == 1) {
            final Player player = (Player)sender;
            final Player target = player.getServer().getPlayerExact(args[0]);
            if (target == null) {
                Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("error.player.offline"), args[0]));
            } else if (target == player) {
                Message.sendMessage(player, Message.getLanguage(player).getString("command.tpa.self"));
            } else if (PlayerConfig.get((OfflinePlayer)player).getKeys(false).contains("tpa-request-sent")) {
                Message.sendMessage(player, Message.getLanguage(player).getString("command.tpa.error"));
            } else {
                int taskID = player.getServer().getScheduler().runTaskLater((Plugin)Players.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        PlayerConfig.setString((OfflinePlayer)player, "tpa-request-sent", null);
                        PlayerConfig.setString((OfflinePlayer)player, "tpa-task", null);
                        PlayerConfig.setString((OfflinePlayer)target, "tpa-request-from", null);
                        Message.sendMessage(target, Message.getLanguage(target).getString("command.tpa.expired"));
                        Message.sendMessage(player, Message.getLanguage(player).getString("command.tpa.expired"));
                    }
                }, 300L).getTaskId();
                PlayerConfig.setInt((OfflinePlayer)player, "tpa-task", taskID);
                PlayerConfig.setString((OfflinePlayer)player, "tpa-request-send", target.getUniqueId().toString());
                PlayerConfig.setString((OfflinePlayer)target, "tpa-request-from", player.getUniqueId().toString());
                Message.sendMessage(target, MessageFormat.format(Message.getLanguage(target).getString("command.tpa.success.target"), player.getName()));
                Message.sendMessage(target, Message.getLanguage(target).getString("command.tpa.success.target2"));
                Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.tpa.success.sender"), player.getName()));
                Message.sendMessage(player, Message.getLanguage(player).getString("command.tpa.success.sender2"));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1) {
            for (Player players : sender.getServer().getOnlinePlayers()) {
                commands.add(players.getName());
            }
        }
        return commands;
    }
}

