/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.pvp;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class PVPCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player;
            if (args.length == 0) {
                Player player2 = (Player)sender;
                if (PlayerConfig.get((OfflinePlayer)player2).getBoolean("pvp")) {
                    PlayerConfig.setBoolean((OfflinePlayer)player2, "pvp", false);
                } else {
                    PlayerConfig.setBoolean((OfflinePlayer)player2, "pvp", true);
                }
                this.sendMessage(player2);
            } else if (args.length == 1 && (player = (Player)sender).hasPermission("players.command.pvp.others")) {
                Player target = player.getServer().getPlayerExact(args[0]);
                if (target == player) {
                    if (PlayerConfig.get((OfflinePlayer)target).getBoolean("pvp")) {
                        PlayerConfig.setBoolean((OfflinePlayer)target, "pvp", false);
                    } else {
                        PlayerConfig.setBoolean((OfflinePlayer)target, "pvp", true);
                    }
                    this.sendMessageTarget(player, target);
                } else if (target == null) {
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("error.player.offline"), args[0]));
                } else if (target.hasPermission("players.command.pvp.exempt")) {
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.pvp.exempt"), target.getName()));
                } else {
                    if (PlayerConfig.get((OfflinePlayer)target).getBoolean("pvp")) {
                        PlayerConfig.setBoolean((OfflinePlayer)target, "pvp", false);
                    } else {
                        PlayerConfig.setBoolean((OfflinePlayer)target, "pvp", true);
                    }
                    this.sendMessageTarget(player, target);
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1 && sender.hasPermission("players.command.pvp.others")) {
            for (Player players : sender.getServer().getOnlinePlayers()) {
                commands.add(players.getName());
            }
        }
        return commands;
    }

    private boolean hasPVP(Player player) {
        return PlayerConfig.get((OfflinePlayer)player).getBoolean("pvp");
    }

    private void sendMessage(Player player) {
        if (this.hasPVP(player)) {
            Message.sendMessage(player, Message.getLanguage(player).getString("command.pvp.enable"));
        } else {
            Message.sendMessage(player, Message.getLanguage(player).getString("command.pvp.disable"));
        }
    }

    private void sendMessageTarget(Player player, Player target) {
        if (this.hasPVP(target)) {
            Message.sendMessage(target, MessageFormat.format(Message.getLanguage(target).getString("command.pvp.target.true"), player.getName()));
            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.pvp.sender.true"), target.getName()));
        } else {
            Message.sendMessage(target, MessageFormat.format(Message.getLanguage(target).getString("command.pvp.target.false"), player.getName()));
            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.pvp.sender.false"), target.getName()));
        }
    }
}

