/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.points.sub;

import java.text.MessageFormat;
import net.achymake.players.api.PointsProvider;
import net.achymake.players.commands.points.PointsSubCommand;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Reset
extends PointsSubCommand {
    @Override
    public String getName() {
        return "reset";
    }

    @Override
    public String getDescription() {
        return "reset points from player account";
    }

    @Override
    public String getSyntax() {
        return "/points reset player amount";
    }

    @Override
    public void perform(CommandSender sender, String[] args) {
        if (sender.hasPermission("players.command.points.reset")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (args.length == 2) {
                    Player target = player.getServer().getPlayerExact(args[1]);
                    if (target != null) {
                        PointsProvider.resetPoints((OfflinePlayer)target);
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.points.reset"), target.getName()));
                    } else {
                        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[1]);
                        if (PlayerConfig.exist(offlinePlayer)) {
                            PointsProvider.resetPoints(offlinePlayer);
                            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.points.reset"), offlinePlayer.getName()));
                        } else {
                            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("error.player.null"), offlinePlayer.getName()));
                        }
                    }
                }
            } else if (args.length == 2) {
                Player target = sender.getServer().getPlayerExact(args[1]);
                if (target != null) {
                    PointsProvider.resetPoints((OfflinePlayer)target);
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.points.reset"), target.getName()));
                } else {
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[1]);
                    if (PlayerConfig.exist(offlinePlayer)) {
                        PointsProvider.resetPoints(offlinePlayer);
                        Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.points.reset"), offlinePlayer.getName()));
                    } else {
                        Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("error.player.null"), offlinePlayer.getName()));
                    }
                }
            }
        }
    }
}

