/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.points.sub;

import java.text.MessageFormat;
import net.achymake.players.api.PointsProvider;
import net.achymake.players.commands.points.PointsSubCommand;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Give
extends PointsSubCommand {
    @Override
    public String getName() {
        return "give";
    }

    @Override
    public String getDescription() {
        return "give points to player account";
    }

    @Override
    public String getSyntax() {
        return "/points give player amount";
    }

    @Override
    public void perform(CommandSender sender, String[] args) {
        Player player;
        if (sender instanceof Player && (player = (Player)sender).hasPermission("players.command.points.give") && args.length == 3) {
            if (PointsProvider.getPointsRaw((OfflinePlayer)player) >= Double.parseDouble(args[2])) {
                Player target = player.getServer().getPlayerExact(args[1]);
                if (target != null) {
                    PointsProvider.addPoints((OfflinePlayer)target, Double.parseDouble(args[2]));
                    PointsProvider.removePoints((OfflinePlayer)player, Double.parseDouble(args[2]));
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.points.give"), target.getName(), PointsProvider.getFormat(Double.parseDouble(args[2]))));
                } else {
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[1]);
                    if (PlayerConfig.exist(offlinePlayer)) {
                        PointsProvider.addPoints(offlinePlayer, Double.parseDouble(args[2]));
                        PointsProvider.removePoints((OfflinePlayer)player, Double.parseDouble(args[2]));
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.points.give"), offlinePlayer.getName(), PointsProvider.getFormat(Double.parseDouble(args[2]))));
                    } else {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("error.player.null"), offlinePlayer.getName()));
                    }
                }
            } else {
                Message.sendMessage(player, "&cYou do not have&f " + PointsProvider.getFormat(Double.parseDouble(args[2])));
            }
        }
    }
}

