/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.pay;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.achymake.players.api.EconomyProvider;
import net.achymake.players.files.Message;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class PayCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player && args.length == 2) {
            Player player = (Player)sender;
            Player target = player.getServer().getPlayerExact(args[0]);
            double amount = Double.parseDouble(args[1]);
            if (target != null) {
                if (EconomyProvider.getEconomyRaw((OfflinePlayer)player) >= amount) {
                    EconomyProvider.removeEconomy((OfflinePlayer)player, amount);
                    EconomyProvider.addEconomy((OfflinePlayer)target, amount);
                    Message.sendMessage(target, MessageFormat.format(Message.getLanguage(target).getString("command.pay.target"), player.getName(), EconomyProvider.getFormat(amount)));
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.pay.sender"), EconomyProvider.getFormat(amount), player.getName()));
                } else {
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.pay.error"), EconomyProvider.getFormat(amount), target.getName()));
                }
            } else {
                Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("error.player.offline"), args[0]));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1) {
            for (Player players : sender.getServer().getOnlinePlayers()) {
                commands.add(players.getName());
            }
        }
        if (args.length == 2) {
            commands.add("50");
            commands.add("100");
            commands.add("1000");
        }
        return commands;
    }
}

