/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.nickname;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class NicknameCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            if (args.length == 0) {
                Player player = (Player)sender;
                PlayerConfig.setString((OfflinePlayer)player, "custom-name", null);
                player.setDisplayName(player.getName());
                Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.nickname.changed"), player.getName()));
            } else if (args.length == 1) {
                Player player = (Player)sender;
                String nickname = args[0];
                player.setDisplayName(Message.color(nickname));
                PlayerConfig.setString((OfflinePlayer)player, "custom-name", nickname);
                Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.nickname.changed"), player.getName()));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1) {
            for (Player players : sender.getServer().getOnlinePlayers()) {
                commands.add(players.getName());
            }
        }
        return commands;
    }
}

