/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.mute;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class MuteCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player && args.length == 1) {
            Player player = (Player)sender;
            Player target = player.getServer().getPlayer(args[0]);
            if (target == player) {
                this.toggleMute(player, target);
            } else if (target == null) {
                Message.sendMessage(sender, MessageFormat.format(Message.getLanguage(player).getString("error.player.offline"), args[0]));
            } else {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[0]);
                if (PlayerConfig.exist(offlinePlayer)) {
                    if (target.hasPermission("players.command.mute.exempt")) {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.mute.exempt"), target.getName()));
                    } else {
                        this.toggleMute(player, target);
                    }
                } else {
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("error.player.null"), args[0]));
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1) {
            for (Player players : sender.getServer().getOnlinePlayers()) {
                commands.add(players.getName());
            }
        }
        return commands;
    }

    private void toggleMute(Player player, Player target) {
        if (PlayerConfig.get((OfflinePlayer)target).getBoolean("muted")) {
            PlayerConfig.setBoolean((OfflinePlayer)target, "muted", false);
            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.mute.disable"), target.getName()));
        } else {
            PlayerConfig.setBoolean((OfflinePlayer)target, "muted", false);
            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.mute.enable"), target.getName()));
        }
    }
}

