/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.motd;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.achymake.players.files.Message;
import net.achymake.players.files.MotdConfig;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class MotdCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 0) {
                for (String motd : MotdConfig.get().getStringList("motd")) {
                    Message.sendMessage(player, MessageFormat.format(motd, player.getName()));
                }
            } else if (args.length == 1) {
                if (MotdConfig.get().getKeys(false).contains(args[0])) {
                    for (String motd : MotdConfig.get().getStringList(args[0])) {
                        Message.sendMessage(player, MessageFormat.format(motd, player.getName()));
                    }
                } else {
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.motd.error"), args[0]));
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1) {
            for (String motd : MotdConfig.get().getKeys(false)) {
                commands.add(motd);
            }
        }
        return commands;
    }
}

