/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.kit;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.achymake.players.files.KitConfig;
import net.achymake.players.files.Message;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class KitCommand
implements CommandExecutor,
TabCompleter {
    private final HashMap<String, Long> cooldown = new HashMap();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block2: {
            Player player;
            block3: {
                if (!(sender instanceof Player)) break block2;
                if (args.length != 0) break block3;
                Player player2 = (Player)sender;
                Message.sendMessage(player2, Message.getLanguage(player2).getString("command.kit.title"));
                for (String kitNames : KitConfig.get().getKeys(false)) {
                    if (!player2.hasPermission("players.command.kit." + kitNames)) continue;
                    Message.sendMessage(player2, MessageFormat.format(Message.getLanguage(player2).getString("command.kit.listed"), kitNames));
                }
                break block2;
            }
            if (args.length != 1 || !(player = (Player)sender).hasPermission("players.command.kit." + args[0].toLowerCase())) break block2;
            for (String kitNames : KitConfig.get().getKeys(false)) {
                if (!args[0].equals(kitNames)) continue;
                this.giveKit(player, args[0]);
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1) {
            for (String kitName : KitConfig.get().getKeys(false)) {
                if (!sender.hasPermission("players.kit." + kitName)) continue;
                commands.add(kitName);
            }
        }
        return commands;
    }

    private void giveKit(Player player, String kitName) {
        if (player.hasPermission("players.exempt.cooldown")) {
            this.dropKit(player, kitName);
            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.kit.received"), kitName));
        } else if (!this.cooldown.containsKey(player.getUniqueId() + kitName)) {
            this.cooldown.put(player.getUniqueId() + kitName, System.currentTimeMillis());
            this.dropKit(player, kitName);
            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.kit.received"), kitName));
        } else {
            Long timeElapsed = System.currentTimeMillis() - this.cooldown.get(player.getUniqueId() + kitName);
            String cooldownTimer = KitConfig.get().getString(kitName + ".cooldown");
            Integer integer = Integer.valueOf(cooldownTimer.replace(cooldownTimer, cooldownTimer + "000"));
            if (timeElapsed > (long)integer.intValue()) {
                this.cooldown.put(player.getUniqueId() + kitName, System.currentTimeMillis());
                this.dropKit(player, kitName);
                Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.kit.received"), kitName));
            } else {
                long timer = (long)integer.intValue() - timeElapsed;
                Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.kit.error"), String.valueOf(timer).substring(0, String.valueOf(timer).length() - 3)));
            }
        }
    }

    private void dropKit(Player player, String kitName) {
        for (ItemStack items : this.getKit(kitName)) {
            player.getWorld().dropItem(player.getLocation(), items);
        }
    }

    private List<ItemStack> getKit(String kitName) {
        ArrayList<ItemStack> giveItems = new ArrayList<ItemStack>();
        for (String items : KitConfig.get().getConfigurationSection(kitName + ".materials").getKeys(false)) {
            ItemStack item = new ItemStack(Material.valueOf((String)KitConfig.get().getString(kitName + ".materials." + items + ".type")));
            ItemMeta itemMeta = item.getItemMeta();
            if (KitConfig.get().getKeys(true).contains(kitName + ".materials." + items + ".name")) {
                itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)KitConfig.get().getString(kitName + ".materials." + items + ".name")));
            }
            if (KitConfig.get().getKeys(true).contains(kitName + ".materials." + items + ".lore")) {
                ArrayList<String> lore = new ArrayList<String>();
                for (String message : KitConfig.get().getStringList(kitName + ".materials." + items + ".lore")) {
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                }
                itemMeta.setLore(lore);
            }
            if (KitConfig.get().getKeys(true).contains(kitName + ".materials." + items + ".enchantments")) {
                for (String enchantList : KitConfig.get().getConfigurationSection(kitName + ".materials." + items + ".enchantments").getKeys(false)) {
                    itemMeta.addEnchant(Enchantment.getByName((String)KitConfig.get().getString(kitName + ".materials." + items + ".enchantments." + enchantList + ".type")), KitConfig.get().getInt(kitName + ".materials." + items + ".enchantments." + enchantList + ".amount"), true);
                }
            }
            item.setItemMeta(itemMeta);
            item.setAmount(KitConfig.get().getInt(kitName + ".materials." + items + ".amount"));
            giveItems.add(item);
        }
        return giveItems;
    }
}

