/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.jail;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.achymake.players.files.JailConfig;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class JailCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player && args.length == 1) {
            Player player = (Player)sender;
            if (JailConfig.get().getKeys(false).contains("jail")) {
                Player target = sender.getServer().getPlayerExact(args[0]);
                if (target == player) {
                    if (PlayerConfig.get((OfflinePlayer)target).getBoolean("jailed")) {
                        this.toggleJail(player, target);
                    } else {
                        this.toggleJail(player, target);
                    }
                } else if (target == null) {
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("error.player.offline"), args[0]));
                } else if (target.hasPermission("players.command.jail.exempt")) {
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.jail.exempt"), target.getName()));
                } else if (PlayerConfig.get((OfflinePlayer)target).getBoolean("jailed")) {
                    this.toggleJail(player, target);
                } else {
                    this.toggleJail(player, target);
                }
            } else {
                Message.sendMessage(player, Message.getLanguage(player).getString("command.jail.error"));
            }
        }
        return true;
    }

    private void toggleJail(Player player, Player target) {
        if (PlayerConfig.get((OfflinePlayer)player).getBoolean("jailed")) {
            PlayerConfig.getLocation((OfflinePlayer)player, "jail").getChunk().load();
            player.teleport(PlayerConfig.getLocation((OfflinePlayer)player, "jail"));
            PlayerConfig.setString((OfflinePlayer)player, "jail", null);
            PlayerConfig.setBoolean((OfflinePlayer)target, "jailed", false);
            PlayerConfig.setString((OfflinePlayer)target, "last-location", null);
            Message.sendMessage(target, MessageFormat.format(Message.getLanguage(target).getString("command.jail.disable.target"), player.getName()));
            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.jail.disable.sender"), target.getName()));
        } else {
            PlayerConfig.setLocation(player, "jail");
            JailConfig.getJail().getChunk().load();
            player.teleport(JailConfig.getJail());
            PlayerConfig.setBoolean((OfflinePlayer)target, "jailed", true);
            PlayerConfig.setString((OfflinePlayer)target, "last-location", null);
            Message.sendMessage(target, MessageFormat.format(Message.getLanguage(target).getString("command.jail.enable.target"), player.getName()));
            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.jail.enable.sender"), target.getName()));
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1) {
            for (Player players : sender.getServer().getOnlinePlayers()) {
                commands.add(players.getName());
            }
        }
        return commands;
    }
}

