/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.inventory;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.achymake.players.files.Message;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class InventoryCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player && args.length == 1) {
            Player player = (Player)sender;
            Player target = player.getServer().getPlayerExact(args[0]);
            if (target == player) {
                Message.sendMessage(player, Message.getLanguage(player).getString("command.inventory.error"));
            } else if (target == null) {
                Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("error.player.offline"), args[0]));
            } else if (target.hasPermission("players.command.inventory.exempt")) {
                Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.inventory.exempt"), target.getName()));
            } else {
                player.openInventory((Inventory)target.getInventory());
                Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.inventory.success"), target.getName()));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1) {
            for (Player players : sender.getServer().getOnlinePlayers()) {
                commands.add(players.getName());
            }
        }
        return commands;
    }
}

