/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.information;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import net.achymake.players.api.EconomyProvider;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class InformationCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 1) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[0]);
                if (PlayerConfig.exist(offlinePlayer)) {
                    Message.sendMessage(player, Message.getLanguage(player).getString("command.information.title"));
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.information.name"), offlinePlayer.getName()));
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.information.custom-name"), PlayerConfig.get(offlinePlayer).getString("custom-name")));
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.information.balance"), EconomyProvider.getEconomy(offlinePlayer)));
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.information.max-homes"), PlayerConfig.get(offlinePlayer).getInt("max-homes")));
                    if (offlinePlayer.isBanned()) {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.information.banned.true"), offlinePlayer.isBanned()));
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.information.banned.reason"), sender.getServer().getBanList(BanList.Type.NAME).getBanEntry(offlinePlayer.getName()).getReason()));
                    } else {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.information.banned.false"), offlinePlayer.isBanned()));
                    }
                    if (PlayerConfig.get(offlinePlayer).getConfigurationSection("homes").getKeys(false).size() > 0) {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.information.homes.title"), EconomyProvider.getEconomy(offlinePlayer)));
                        for (String homeNames : PlayerConfig.get(offlinePlayer).getConfigurationSection("homes").getKeys(false)) {
                            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.information.homes.listed"), homeNames));
                        }
                    }
                    if (PlayerConfig.get(offlinePlayer).getBoolean("vanished")) {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.information.vanished.true"), PlayerConfig.get(offlinePlayer).getBoolean("vanished")));
                    } else {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.information.vanished.false"), PlayerConfig.get(offlinePlayer).getBoolean("vanished")));
                    }
                    if (offlinePlayer.isOnline()) {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.information.online.true"), offlinePlayer.isOnline()));
                    } else {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.information.online.false"), offlinePlayer.isOnline()));
                    }
                    if (offlinePlayer.isOnline()) {
                        Player targetOnline = player.getServer().getPlayerExact(args[0]);
                        World world = targetOnline.getWorld();
                        int x = (int)targetOnline.getLocation().getX();
                        int y = (int)targetOnline.getLocation().getY();
                        int z = (int)targetOnline.getLocation().getZ();
                        Message.sendMessage(player, Message.getLanguage(player).getString("command.information.location.title"));
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.information.location.listed"), world.getName(), x, y, z));
                    } else {
                        String quitWorld = PlayerConfig.get(offlinePlayer).getString("quit-location.world");
                        int x = (int)PlayerConfig.get(offlinePlayer).getDouble("quit-location.x");
                        int y = (int)PlayerConfig.get(offlinePlayer).getDouble("quit-location.y");
                        int z = (int)PlayerConfig.get(offlinePlayer).getDouble("quit-location.z");
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.information.last-online"), SimpleDateFormat.getDateInstance().format(offlinePlayer.getLastPlayed())));
                        Message.sendMessage(player, Message.getLanguage().getString("command.information.quit-location.title"));
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.information.quit-location.listed"), quitWorld, x, y, z));
                    }
                } else {
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("error.player.null"), args[0]));
                }
            }
        } else if (args.length == 1) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[0]);
            if (PlayerConfig.exist(offlinePlayer)) {
                Message.sendMessage(sender, Message.getLanguage().getString("command.information.title"));
                Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.information.name"), offlinePlayer.getName()));
                Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.information.custom-name"), PlayerConfig.get(offlinePlayer).getString("custom-name")));
                Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.information.balance"), EconomyProvider.getEconomy(offlinePlayer)));
                Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.information.max-homes"), PlayerConfig.get(offlinePlayer).getInt("max-homes")));
                if (offlinePlayer.isBanned()) {
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.information.banned.true"), offlinePlayer.isBanned()));
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.information.banned.reason"), sender.getServer().getBanList(BanList.Type.NAME).getBanEntry(offlinePlayer.getName()).getReason()));
                } else {
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.information.banned.false"), offlinePlayer.isBanned()));
                }
                if (PlayerConfig.get(offlinePlayer).getConfigurationSection("homes").getKeys(false).size() > 0) {
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.information.homes.title"), EconomyProvider.getEconomy(offlinePlayer)));
                    for (String homeNames : PlayerConfig.get(offlinePlayer).getConfigurationSection("homes").getKeys(false)) {
                        Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.information.homes.listed"), homeNames));
                    }
                }
                if (PlayerConfig.get(offlinePlayer).getBoolean("vanished")) {
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.information.vanished.true"), PlayerConfig.get(offlinePlayer).getBoolean("vanished")));
                } else {
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.information.vanished.false"), PlayerConfig.get(offlinePlayer).getBoolean("vanished")));
                }
                if (offlinePlayer.isOnline()) {
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.information.online.true"), offlinePlayer.isOnline()));
                } else {
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.information.online.false"), offlinePlayer.isOnline()));
                }
                if (offlinePlayer.isOnline()) {
                    Player targetOnline = sender.getServer().getPlayerExact(args[0]);
                    World world = targetOnline.getWorld();
                    int x = (int)targetOnline.getLocation().getX();
                    int y = (int)targetOnline.getLocation().getY();
                    int z = (int)targetOnline.getLocation().getZ();
                    Message.sendMessage(sender, Message.getLanguage().getString("command.information.location.title"));
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.information.location.listed"), world.getName(), x, y, z));
                } else {
                    String quitWorld = PlayerConfig.get(offlinePlayer).getString("quit-location.world");
                    int x = (int)PlayerConfig.get(offlinePlayer).getDouble("quit-location.x");
                    int y = (int)PlayerConfig.get(offlinePlayer).getDouble("quit-location.y");
                    int z = (int)PlayerConfig.get(offlinePlayer).getDouble("quit-location.z");
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.information.last-online"), SimpleDateFormat.getDateInstance().format(offlinePlayer.getLastPlayed())));
                    Message.sendMessage(sender, Message.getLanguage().getString("command.information.quit-location.title"));
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.information.quit-location.listed"), quitWorld, x, y, z));
                }
            } else {
                Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("error.player.null"), args[0]));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1) {
            for (OfflinePlayer offlinePlayer : sender.getServer().getOfflinePlayers()) {
                commands.add(offlinePlayer.getName());
            }
        }
        return commands;
    }
}

