/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.homes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.achymake.players.commands.homes.HomesSubCommand;
import net.achymake.players.commands.homes.sub.Delete;
import net.achymake.players.commands.homes.sub.Teleport;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class HomesCommand
implements CommandExecutor,
TabCompleter {
    public ArrayList<HomesSubCommand> homesSubCommands = new ArrayList();

    public HomesCommand() {
        this.homesSubCommands.add(new Delete());
        this.homesSubCommands.add(new Teleport());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block6: {
            if (!(sender instanceof Player)) break block6;
            if (args.length == 0) {
                Player player = (Player)sender;
                if (PlayerConfig.get((OfflinePlayer)player).getConfigurationSection("homes").getKeys(false).size() > 0) {
                    Message.sendMessage(player, Message.getLanguage(player).getString("command.homes.title"));
                    for (String listedHomes : PlayerConfig.get((OfflinePlayer)player).getConfigurationSection("homes").getKeys(false)) {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.homes.listed"), listedHomes));
                    }
                } else {
                    Message.sendMessage(player, Message.getLanguage(player).getString("command.homes.error"));
                }
            } else {
                for (HomesSubCommand commands : this.homesSubCommands) {
                    if (!args[0].equals(commands.getName())) continue;
                    commands.perform((Player)sender, args);
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("players.command.homes.delete")) {
                commands.add("delete");
            }
            if (sender.hasPermission("players.command.homes.teleport")) {
                commands.add("teleport");
            }
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("teleport")) {
                for (OfflinePlayer offlinePlayers : sender.getServer().getOfflinePlayers()) {
                    commands.add(offlinePlayers.getName());
                }
            } else if (args[0].equalsIgnoreCase("delete")) {
                for (OfflinePlayer offlinePlayers : sender.getServer().getOfflinePlayers()) {
                    commands.add(offlinePlayers.getName());
                }
            }
        }
        if (args.length == 3 && sender.hasPermission("players.command.homes.teleport")) {
            OfflinePlayer offlinePlayer = sender.getServer().getOfflinePlayer(args[1]);
            for (String home : PlayerConfig.get(offlinePlayer).getConfigurationSection("homes").getKeys(false)) {
                commands.add(home);
            }
        }
        return commands;
    }
}

