/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.home;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.achymake.players.api.EconomyProvider;
import net.achymake.players.files.Config;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class HomeCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            if (args.length == 0) {
                Player player = (Player)sender;
                if (PlayerConfig.get((OfflinePlayer)player).getConfigurationSection("homes").getKeys(false).contains("home")) {
                    PlayerConfig.getLocation((OfflinePlayer)player, "homes.home").getChunk().load();
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.home.success"), "home"));
                    player.teleport(PlayerConfig.getLocation((OfflinePlayer)player, "homes.home"));
                } else {
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.home.error"), "home"));
                }
            } else if (args.length == 1) {
                Player player = (Player)sender;
                String homeName = args[0];
                if (homeName.equalsIgnoreCase("buy")) {
                    Object[] objectArray = new Object[1];
                    new Config();
                    objectArray[0] = EconomyProvider.getFormat(Config.get().getDouble("homes.cost"));
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.home.buy.cost"), objectArray));
                } else if (homeName.equalsIgnoreCase("bed")) {
                    if (player.getBedSpawnLocation() != null) {
                        if (player.hasPermission("players.command.home.bed")) {
                            Location location = player.getBedSpawnLocation();
                            location.setPitch(player.getLocation().getPitch());
                            location.setYaw(player.getLocation().getYaw());
                            player.getBedSpawnLocation().getChunk().load();
                            player.teleport(location);
                            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.home.success"), args[0]));
                        }
                    } else {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.home.error"), args[0]));
                    }
                } else if (PlayerConfig.get((OfflinePlayer)player).getConfigurationSection("homes").getKeys(false).contains(homeName)) {
                    PlayerConfig.getLocation((OfflinePlayer)player, "homes." + args[0]).getChunk().load();
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.home.success"), args[0]));
                    player.teleport(PlayerConfig.getLocation((OfflinePlayer)player, "homes." + args[0]));
                } else {
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.home.error"), args[0]));
                }
            } else if (args.length == 2) {
                Player player = (Player)sender;
                String homeName = args[0];
                if (homeName.equalsIgnoreCase("buy")) {
                    int amount = Integer.parseInt(args[1]);
                    if (player.hasPermission("players.command.home.buy")) {
                        if (EconomyProvider.getEconomyRaw((OfflinePlayer)player) >= Config.get().getDouble("homes.cost") * (double)amount) {
                            PlayerConfig.setInt((OfflinePlayer)player, "max-homes", amount);
                            EconomyProvider.removeEconomy((OfflinePlayer)player, Config.get().getDouble("homes.cost") * (double)amount);
                            Object[] objectArray = new Object[2];
                            objectArray[0] = amount;
                            new Config();
                            objectArray[1] = EconomyProvider.getFormat(Config.get().getDouble("homes.cost"));
                            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.home.buy.success"), objectArray));
                        } else {
                            Object[] objectArray = new Object[1];
                            new Config();
                            objectArray[0] = EconomyProvider.getFormat(Config.get().getDouble("homes.cost"));
                            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.home.buy.error"), objectArray));
                        }
                    }
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        Player player = (Player)sender;
        if (args.length == 1) {
            for (String home : PlayerConfig.get((OfflinePlayer)player).getConfigurationSection("homes").getKeys(false)) {
                commands.add(home);
            }
            if (sender.hasPermission("players.command.home.bed")) {
                commands.add("bed");
            }
            if (sender.hasPermission("players.command.home.buy")) {
                commands.add("buy");
            }
        }
        if (args.length == 2 && sender.hasPermission("players.command.home.buy") && args[0].equalsIgnoreCase("buy")) {
            commands.add("1");
            commands.add("2");
            commands.add("3");
        }
        return commands;
    }
}

