/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.gamemode.sub;

import java.text.MessageFormat;
import net.achymake.players.commands.gamemode.GamemodeSubCommand;
import net.achymake.players.files.Message;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Adventure
extends GamemodeSubCommand {
    @Override
    public String getName() {
        return "adventure";
    }

    @Override
    public String getDescription() {
        return "changes gamemode to adventure";
    }

    @Override
    public String getSyntax() {
        return "/gamemode adventure target";
    }

    @Override
    public void perform(CommandSender sender, String[] args) {
        if (sender.hasPermission("players.command.gamemode.adventure")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (args.length == 1) {
                    player.setGameMode(GameMode.ADVENTURE);
                    Message.sendMessage(player, Message.getLanguage(player).getString("command.gamemode.adventure.self"));
                } else if (args.length == 2 && sender.hasPermission("players.command.gamemode.others")) {
                    Player target = sender.getServer().getPlayerExact(args[1]);
                    if (target != null) {
                        if (target == player) {
                            target.setGameMode(GameMode.ADVENTURE);
                            Message.sendMessage(target, MessageFormat.format(Message.getLanguage(target).getString("command.gamemode.adventure.others.target"), player.getName()));
                            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.gamemode.adventure.others.sender"), target.getName()));
                        } else if (target.hasPermission("players.command.gamemode.exempt")) {
                            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.gamemode.exempt"), target.getName()));
                        } else {
                            target.setGameMode(GameMode.ADVENTURE);
                            Message.sendMessage(target, MessageFormat.format(Message.getLanguage(target).getString("command.gamemode.adventure.others.target"), player.getName()));
                            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.gamemode.adventure.others.sender"), target.getName()));
                        }
                    } else {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("error.player.offline"), args[0]));
                    }
                }
            } else if (args.length == 2 && sender.hasPermission("players.command.gamemode.others")) {
                Player target = sender.getServer().getPlayerExact(args[1]);
                if (target != null) {
                    if (target.hasPermission("players.command.gamemode.exempt")) {
                        Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.gamemode.exempt"), target.getName()));
                    } else {
                        target.setGameMode(GameMode.ADVENTURE);
                        Message.sendMessage(target, MessageFormat.format(Message.getLanguage(target).getString("command.gamemode.adventure.others.target"), sender.getName()));
                        Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.gamemode.adventure.others.sender"), target.getName()));
                    }
                } else {
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("error.player.offline"), args[0]));
                }
            }
        }
    }
}

