/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.fly;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.achymake.players.files.Message;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class FlyCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 0) {
                this.toggleFly(player);
            } else if (args.length == 1 && player.hasPermission("players.command.fly.others")) {
                Player target = player.getServer().getPlayerExact(args[0]);
                if (target == null) {
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("error.player.offline"), args[0]));
                } else if (target == player) {
                    this.toggleFly(player);
                } else if (target.hasPermission("players.command.fly.exempt")) {
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.fly.exempt"), target.getName()));
                } else {
                    this.toggleFly(player);
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1 && sender.hasPermission("players.command.fly.others")) {
            for (Player players : sender.getServer().getOnlinePlayers()) {
                commands.add(players.getName());
            }
        }
        return commands;
    }

    private void toggleFly(Player player) {
        if (player.getAllowFlight()) {
            player.setAllowFlight(false);
            new Message();
            new Message();
            Message.sendMessage(player, Message.getLanguage(player).getString("command.fly.disable"));
        } else {
            player.setAllowFlight(true);
            new Message();
            new Message();
            Message.sendMessage(player, Message.getLanguage(player).getString("command.fly.enable"));
        }
    }
}

