/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.feed;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.achymake.players.files.Config;
import net.achymake.players.files.Message;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class FeedCommand
implements CommandExecutor,
TabCompleter {
    private static final HashMap<UUID, Long> cooldown = new HashMap();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            if (args.length == 0) {
                Player player = (Player)sender;
                if (player.hasPermission("players.exempt.cooldown")) {
                    player.setFoodLevel(20);
                    Message.sendMessage(player, Message.getLanguage(player).getString("command.feed.success"));
                } else if (!cooldown.containsKey(player.getUniqueId())) {
                    cooldown.put(player.getUniqueId(), System.currentTimeMillis());
                    player.setFoodLevel(20);
                    Message.sendMessage(player, Message.getLanguage(player).getString("command.feed.success"));
                } else {
                    Long timeElapsed = System.currentTimeMillis() - cooldown.get(player.getUniqueId());
                    String cooldownTimer = Config.get().getString("commands.cooldown.feed");
                    Integer integer = Integer.valueOf(cooldownTimer.replace(cooldownTimer, cooldownTimer + "000"));
                    if (timeElapsed > (long)integer.intValue()) {
                        cooldown.put(player.getUniqueId(), System.currentTimeMillis());
                        player.setFoodLevel(20);
                        Message.sendMessage(player, Message.getLanguage(player).getString("command.feed.success"));
                    } else {
                        long timer = (long)integer.intValue() - timeElapsed;
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.feed.error"), String.valueOf(timer).substring(0, String.valueOf(timer).length() - 3)));
                    }
                }
            } else if (args.length == 1) {
                Player player = (Player)sender;
                if (sender.hasPermission("players.command.feed.others")) {
                    Player target = sender.getServer().getPlayerExact(args[0]);
                    if (target == null) {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("error.player.offline"), args[0]));
                    } else {
                        target.setFoodLevel(20);
                        Message.sendMessage(target, MessageFormat.format(Message.getLanguage(target).getString("command.feed.others.target"), player.getName()));
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.feed.others.sender"), target.getName()));
                    }
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1 && sender.hasPermission("players.command.feed.others")) {
            for (Player players : sender.getServer().getOnlinePlayers()) {
                commands.add(players.getName());
            }
        }
        return commands;
    }
}

