/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.enderchest;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.achymake.players.files.Message;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class EnderchestCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 0) {
                player.openInventory(player.getEnderChest());
                if (!Message.getLanguage(player).getString("command.enderchest.self").equals("")) {
                    Message.sendMessage(player, Message.getLanguage(player).getString("command.enderchest.self"));
                }
            } else if (args.length == 1 && player.hasPermission("players.command.enderchest.others")) {
                Player target = player.getServer().getPlayerExact(args[0]);
                if (target == player) {
                    player.openInventory(player.getEnderChest());
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.enderchest.others"), target.getName()));
                } else if (target != null) {
                    if (target.hasPermission("players.command.enderchest.exempt")) {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.enderchest.exempt"), target.getName()));
                    } else {
                        player.openInventory(target.getEnderChest());
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.enderchest.others"), target.getName()));
                    }
                } else {
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("error.player.null"), args[0]));
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1 && sender.hasPermission("players.command.enderchest.others")) {
            for (Player players : sender.getServer().getOnlinePlayers()) {
                commands.add(players.getName());
            }
        }
        return commands;
    }
}

