/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.eco.sub;

import java.text.MessageFormat;
import net.achymake.players.api.EconomyProvider;
import net.achymake.players.commands.eco.EcoSubCommand;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Reset
extends EcoSubCommand {
    @Override
    public String getName() {
        return "reset";
    }

    @Override
    public String getDescription() {
        return "reset eco from player account";
    }

    @Override
    public String getSyntax() {
        return "/eco reset player";
    }

    @Override
    public void perform(CommandSender sender, String[] args) {
        if (sender.hasPermission("players.command.eco.reset")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (args.length == 2) {
                    Player target = player.getServer().getPlayerExact(args[1]);
                    if (target != null) {
                        EconomyProvider.resetEconomy((OfflinePlayer)target);
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.eco.reset"), target.getName()));
                    } else {
                        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[1]);
                        if (PlayerConfig.exist(offlinePlayer)) {
                            EconomyProvider.resetEconomy(offlinePlayer);
                            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.eco.reset"), offlinePlayer.getName()));
                        } else {
                            Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("error.player.null"), offlinePlayer.getName()));
                        }
                    }
                }
            } else if (args.length == 2) {
                Player target = sender.getServer().getPlayerExact(args[1]);
                if (target != null) {
                    EconomyProvider.resetEconomy((OfflinePlayer)target);
                    Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.eco.reset"), target.getName()));
                } else {
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[1]);
                    if (PlayerConfig.exist(offlinePlayer)) {
                        EconomyProvider.resetEconomy(offlinePlayer);
                        Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("command.eco.reset"), offlinePlayer.getName()));
                    } else {
                        Message.sendMessage(sender, MessageFormat.format(Message.getLanguage().getString("error.player.null"), offlinePlayer.getName()));
                    }
                }
            }
        }
    }
}

