/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.commands.balance;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.achymake.players.api.EconomyProvider;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class BalanceCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 0) {
                Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.balance.self"), EconomyProvider.getEconomy((OfflinePlayer)player)));
            }
            if (args.length == 1 && player.hasPermission("players.command.balance.others")) {
                Player target = player.getServer().getPlayerExact(args[0]);
                if (target != null) {
                    Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.balance.others"), target.getName(), EconomyProvider.getEconomy((OfflinePlayer)target)));
                } else {
                    OfflinePlayer offlinePlayer = player.getServer().getOfflinePlayer(args[0]);
                    if (PlayerConfig.exist(offlinePlayer)) {
                        new Message();
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("command.balance.others"), offlinePlayer.getName(), EconomyProvider.getEconomy(offlinePlayer)));
                    } else {
                        Message.sendMessage(player, MessageFormat.format(Message.getLanguage(player).getString("error.player.null"), args[0]));
                    }
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1 && sender.hasPermission("players.command.balance.others")) {
            for (OfflinePlayer offlinePlayer : sender.getServer().getOfflinePlayers()) {
                commands.add(offlinePlayer.getName());
            }
        }
        return commands;
    }
}

