/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.api;

import java.text.DecimalFormat;
import net.achymake.players.files.Config;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.OfflinePlayer;

public class PointsProvider {
    public static String getPoints(OfflinePlayer offlinePlayer) {
        return PointsProvider.getFormat(PlayerConfig.get(offlinePlayer).getDouble("points"));
    }

    public static double getPointsRaw(OfflinePlayer offlinePlayer) {
        return PlayerConfig.get(offlinePlayer).getDouble("points");
    }

    public static void addPoints(OfflinePlayer offlinePlayer, double amount) {
        double newAmount = amount + PlayerConfig.get(offlinePlayer).getDouble("points");
        PlayerConfig.setDouble(offlinePlayer, "points", newAmount);
    }

    public static void removePoints(OfflinePlayer offlinePlayer, double amount) {
        double newAmount = PlayerConfig.get(offlinePlayer).getDouble("points") - amount;
        PlayerConfig.setDouble(offlinePlayer, "points", newAmount);
    }

    public static void setPoints(OfflinePlayer offlinePlayer, double amount) {
        PlayerConfig.setDouble(offlinePlayer, "points", amount);
    }

    public static void resetPoints(OfflinePlayer offlinePlayer) {
        new Config();
        PlayerConfig.setDouble(offlinePlayer, "points", Config.get().getDouble("points.starting-points"));
    }

    public static String getFormat(double value) {
        new Config();
        DecimalFormat balance = new DecimalFormat(Config.get().getString("points.format"));
        String formatted = balance.format(value);
        new Config();
        return Config.get().getString("points.currency") + formatted;
    }
}

