/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.api;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.achymake.players.Players;
import net.achymake.players.api.EconomyProvider;
import net.achymake.players.api.PointsProvider;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderProvider
extends PlaceholderExpansion {
    public String getIdentifier() {
        return "players";
    }

    public String getAuthor() {
        return "AchyMake";
    }

    public String getVersion() {
        return Players.getInstance().getDescription().getVersion();
    }

    public boolean canRegister() {
        return true;
    }

    public boolean register() {
        return super.register();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String params) {
        if (player == null) {
            return "";
        }
        if (params.equals("name")) {
            if (PlayerConfig.get((OfflinePlayer)player).getKeys(false).contains("custom-name")) {
                return Message.color(PlayerConfig.get((OfflinePlayer)player).getString("custom-name"));
            }
            return Message.color(PlayerConfig.get((OfflinePlayer)player).getString("name"));
        }
        if (params.equals("vanished")) {
            if (PlayerConfig.get((OfflinePlayer)player).getBoolean("vanished")) {
                return Message.getLanguage(player).getString("placeholders.vanished.enabled");
            }
            return Message.getLanguage(player).getString("placeholders.vanished.disabled");
        }
        if (params.equals("online_players")) {
            return String.valueOf(player.getServer().getOnlinePlayers().size() - Players.getInstance().getVanished().size());
        }
        if (params.equals("account")) {
            return EconomyProvider.getEconomy((OfflinePlayer)player);
        }
        if (params.equals("points")) {
            return PointsProvider.getPoints((OfflinePlayer)player);
        }
        return super.onPlaceholderRequest(player, params);
    }
}

