/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.players.api;

import java.text.DecimalFormat;
import net.achymake.players.Players;
import net.achymake.players.api.PlaceholderProvider;
import net.achymake.players.api.VaultEconomyProvider;
import net.achymake.players.files.Config;
import net.achymake.players.files.Message;
import net.achymake.players.files.PlayerConfig;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;

public class EconomyProvider {
    public static String getEconomy(OfflinePlayer offlinePlayer) {
        return EconomyProvider.getFormat(PlayerConfig.get(offlinePlayer).getDouble("account"));
    }

    public static double getEconomyRaw(OfflinePlayer offlinePlayer) {
        return PlayerConfig.get(offlinePlayer).getDouble("account");
    }

    public static void addEconomy(OfflinePlayer offlinePlayer, double amount) {
        double newAmount = amount + PlayerConfig.get(offlinePlayer).getDouble("account");
        PlayerConfig.setDouble(offlinePlayer, "account", newAmount);
    }

    public static void removeEconomy(OfflinePlayer offlinePlayer, double amount) {
        double newAmount = PlayerConfig.get(offlinePlayer).getDouble("account") - amount;
        PlayerConfig.setDouble(offlinePlayer, "account", newAmount);
    }

    public static void setEconomy(OfflinePlayer offlinePlayer, double amount) {
        PlayerConfig.setDouble(offlinePlayer, "account", amount);
    }

    public static void resetEconomy(OfflinePlayer offlinePlayer) {
        PlayerConfig.setDouble(offlinePlayer, "account", Config.get().getDouble("economy.starting-balance"));
    }

    public static String getFormat(Double value) {
        DecimalFormat balance = new DecimalFormat(Config.get().getString("economy.format"));
        String formatted = balance.format(value);
        return Config.get().getString("economy.currency") + formatted;
    }

    public void setup(Players plugin) {
        if (plugin.getServer().getPluginManager().getPlugin("Vault") != null) {
            plugin.getServer().getServicesManager().register(Economy.class, (Object)new VaultEconomyProvider(plugin), (Plugin)plugin, ServicePriority.Normal);
            Message.sendLog("hooked to Vault");
        } else {
            Message.sendLog("You have to install 'Vault'");
            plugin.getPluginLoader().disablePlugin((Plugin)plugin);
        }
        if (plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderProvider().register();
        } else {
            Message.sendLog("You have to install 'PlaceholderAPI'");
            plugin.getPluginLoader().disablePlugin((Plugin)plugin);
        }
    }
}

