/*
 * Decompiled with CFR 0.152.
 */
package com.tcoded.playerbountiesplus.manager;

import com.tcoded.playerbountiesplus.PlayerBountiesPlus;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class BountyDataManager {
    private final PlayerBountiesPlus plugin;
    private File bountiesFile;
    private FileConfiguration bountiesConfig;
    private final Object savingFileLock = new Object();
    private final AtomicBoolean savingAsync = new AtomicBoolean(false);
    private final ConcurrentHashMap<UUID, Integer> bounties;

    public BountyDataManager(PlayerBountiesPlus plugin) {
        this.plugin = plugin;
        this.bounties = new ConcurrentHashMap();
    }

    public void init() {
        String bountiesFileName = "bounties.yml";
        this.bountiesFile = new File(this.plugin.getDataFolder(), bountiesFileName);
        if (!this.bountiesFile.exists()) {
            this.plugin.saveResource(bountiesFileName, false);
        }
        this.bountiesConfig = YamlConfiguration.loadConfiguration((File)this.bountiesFile);
        Set keys = this.bountiesConfig.getKeys(false);
        for (String key : keys) {
            try {
                this.bounties.put(UUID.fromString(key), this.bountiesConfig.getInt(key));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public ConcurrentHashMap<UUID, Integer> getBounties() {
        return this.bounties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBounties() {
        Object object = this.savingFileLock;
        synchronized (object) {
            Set keys = this.bountiesConfig.getKeys(false);
            for (String string : keys) {
                this.bountiesConfig.set(string, null);
            }
            for (Map.Entry entry : this.bounties.entrySet()) {
                this.bountiesConfig.set(((UUID)entry.getKey()).toString(), entry.getValue());
            }
            try {
                this.bountiesConfig.save(this.bountiesFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBountiesAsync() {
        while (this.savingAsync.getAndSet(true)) {
            try {
                AtomicBoolean atomicBoolean = this.savingAsync;
                synchronized (atomicBoolean) {
                    this.savingAsync.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this.plugin.getFoliaLib().getImpl().runAsync(() -> {
            this.saveBounties();
            this.savingAsync.set(false);
            AtomicBoolean atomicBoolean = this.savingAsync;
            synchronized (atomicBoolean) {
                this.savingAsync.notifyAll();
            }
        });
    }
}

