/*
 * Decompiled with CFR 0.152.
 */
package com.tcoded.playerbountiesplus.listener;

import com.tcoded.playerbountiesplus.PlayerBountiesPlus;
import com.tcoded.playerbountiesplus.hook.team.AbstractTeamHook;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;

public class DeathListener
implements Listener {
    private PlayerBountiesPlus plugin;

    public DeathListener(PlayerBountiesPlus plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDeath(PlayerDeathEvent event) {
        Player victim = event.getEntity();
        Player killer = victim.getKiller();
        if (killer != null) {
            UUID victimId;
            ConcurrentHashMap<UUID, Integer> bounties = this.plugin.getBountyDataManager().getBounties();
            Integer bounty = bounties.get(victimId = victim.getUniqueId());
            if (bounty == null || bounty == 0) {
                return;
            }
            AbstractTeamHook teamHook = this.plugin.getTeamHook();
            if (teamHook != null && teamHook.isFriendly(killer, victim)) {
                killer.sendMessage(ChatColor.GREEN + "The player you killed has an active bounty but you are in the same clan as they are!");
                return;
            }
            this.plugin.getVaultHook().addMoney(killer, bounty.intValue());
            this.plugin.getServer().broadcastMessage(ChatColor.DARK_RED.toString() + ChatColor.BOLD + String.format("%s claimed the bounty that was placed on %s worth %s", killer.getName(), victim.getName(), bounty));
            bounties.remove(victimId);
            this.plugin.getBountyDataManager().saveBountiesAsync();
        }
    }
}

