/*
 * Decompiled with CFR 0.152.
 */
package com.tcoded.playerbountiesplus.hook;

import com.tcoded.playerbountiesplus.PlayerBountiesPlus;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook {
    private final PlayerBountiesPlus plugin;
    private Economy eco;

    public VaultHook(PlayerBountiesPlus plugin) {
        this.plugin = plugin;
    }

    public boolean init() {
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.eco = (Economy)rsp.getProvider();
        return true;
    }

    public void addMoney(Player player, double amount) {
        this.eco.depositPlayer((OfflinePlayer)player, amount);
    }

    public boolean takeMoney(Player player, double amount) {
        double balance = this.eco.getBalance((OfflinePlayer)player);
        if (balance < amount) {
            return false;
        }
        this.eco.withdrawPlayer((OfflinePlayer)player, amount);
        return true;
    }
}

