/*
 * Decompiled with CFR 0.152.
 */
package com.tcoded.playerbountiesplus;

import com.tcoded.playerbountiesplus.command.BountyCommand;
import com.tcoded.playerbountiesplus.hook.VaultHook;
import com.tcoded.playerbountiesplus.hook.team.AbstractTeamHook;
import com.tcoded.playerbountiesplus.lib.folialib.FoliaLib;
import com.tcoded.playerbountiesplus.listener.DeathListener;
import com.tcoded.playerbountiesplus.manager.BountyDataManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PlayerBountiesPlus
extends JavaPlugin {
    private FoliaLib foliaLib;
    private BountyDataManager bountyDataManager;
    private VaultHook vault;
    private AbstractTeamHook clanHook;

    public void onEnable() {
        this.foliaLib = new FoliaLib(this);
        this.saveDefaultConfig();
        this.bountyDataManager = new BountyDataManager(this);
        this.bountyDataManager.init();
        this.vault = new VaultHook(this);
        boolean ecoPresent = this.vault.init();
        if (!ecoPresent) {
            this.getLogger().severe("No economy is present! Aborting startup!");
            return;
        }
        this.clanHook = AbstractTeamHook.findTeamHook(this);
        if (this.clanHook == null) {
            this.getLogger().warning("There is no supported team/clan/party plugin on the server! Feel free to request support for the plugin you use on GitHub or Discord!");
        }
        PluginCommand bountyCmd = this.getCommand("bounty");
        BountyCommand bountyExec = new BountyCommand(this);
        bountyCmd.setExecutor((CommandExecutor)bountyExec);
        bountyCmd.setTabCompleter((TabCompleter)bountyExec);
        this.getServer().getPluginManager().registerEvents((Listener)new DeathListener(this), (Plugin)this);
    }

    public void onDisable() {
        HandlerList.unregisterAll((Plugin)this);
    }

    public VaultHook getVaultHook() {
        return this.vault;
    }

    public AbstractTeamHook getTeamHook() {
        return this.clanHook;
    }

    public BountyDataManager getBountyDataManager() {
        return this.bountyDataManager;
    }

    public FoliaLib getFoliaLib() {
        return this.foliaLib;
    }
}

