/*
 * Decompiled with CFR 0.152.
 */
package me.maurxce.petteleport.managers;

import java.io.File;
import java.io.IOException;
import me.maurxce.petteleport.Main;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private static FileConfiguration config = new YamlConfiguration();
    private static FileConfiguration lang = new YamlConfiguration();
    private static final File configFile = new File(ConfigManager.getDataFolder(), "config.yml");
    private static final File langFile = new File(ConfigManager.getDataFolder(), "lang.yml");

    public static void loadFiles() {
        if (!ConfigManager.getDataFolder().exists()) {
            ConfigManager.getDataFolder().mkdirs();
        }
        if (!configFile.exists()) {
            ConfigManager.saveResource("config.yml");
        }
        if (!langFile.exists()) {
            ConfigManager.saveResource("lang.yml");
        }
        try {
            ConfigManager.reloadFiles();
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    private static File getDataFolder() {
        return Main.instance.getDataFolder();
    }

    private static void saveResource(String resource) {
        Main.instance.saveResource(resource, false);
    }

    public static void reloadFiles() throws IOException, InvalidConfigurationException {
        config.load(configFile);
        lang.load(langFile);
    }

    public static FileConfiguration getConfig() {
        return config;
    }

    public static FileConfiguration getLang() {
        return lang;
    }
}

