/*
 * Decompiled with CFR 0.152.
 */
package me.maurxce.petteleport.commands;

import java.io.IOException;
import me.maurxce.petteleport.managers.ConfigManager;
import me.maurxce.petteleport.utils.ChatUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class Reload
implements CommandExecutor {
    private final FileConfiguration lang = ConfigManager.getLang();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.hasPermission(sender)) {
            String noPermission = this.lang.getString("no-permission");
            if (this.stringExists(noPermission)) {
                sender.sendMessage(ChatUtils.translate(noPermission));
            }
            return true;
        }
        try {
            String success;
            ConfigManager.reloadFiles();
            if (sender instanceof Player && this.stringExists(success = this.lang.getString("reload-success"))) {
                sender.sendMessage(ChatUtils.translate(success));
            }
            Bukkit.getLogger().info("Successfully reloaded files.");
        }
        catch (IOException | InvalidConfigurationException e) {
            String error;
            if (sender instanceof Player && this.stringExists(error = this.lang.getString("reload-error"))) {
                sender.sendMessage(ChatUtils.translate(error));
            }
            Bukkit.getLogger().warning("Failed to reload files.");
            e.printStackTrace();
        }
        return true;
    }

    private boolean hasPermission(CommandSender sender) {
        return sender instanceof Player && sender.hasPermission("pettp.reload");
    }

    private boolean stringExists(String string) {
        return string != null && !string.equals("");
    }
}

