/*
 * Decompiled with CFR 0.152.
 */
package velariyel.bandages;

import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import velariyel.bandages.BandageManager;
import velariyel.bandages.BandageType;
import velariyel.bandages.Messages;

public class Commands
implements CommandExecutor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command cmd, String alias, String[] args) {
        if (sender instanceof Player && !sender.hasPermission("paperhealing.staff")) {
            Messages.permissionMessage(sender);
            return false;
        }
        if (args.length == 0) {
            Messages.subcmdMessage(sender);
            return false;
        }
        if (args.length == 1) {
            switch (args[0].toUpperCase()) {
                case "GIVE": {
                    Messages.usageMessage(sender);
                    return false;
                }
                case "GIVEALL": {
                    Messages.giveallMessage(sender);
                    return false;
                }
                case "LIST": {
                    Messages.listAll(sender);
                    return false;
                }
            }
            Messages.subcmdMessage(sender);
            return false;
        }
        BandageType type = BandageType.getBandageType(args[1]);
        if (type == null) {
            Messages.bdgtypeMessage(sender);
            return false;
        }
        if (args[0].equalsIgnoreCase("give")) {
            Player target = null;
            int amount = 0;
            if (args.length == 2) {
                if (!(sender instanceof Player)) {
                    Messages.usageMessage(sender);
                    return false;
                }
                target = (Player)sender;
                amount = 1;
            } else if (args.length == 3) {
                target = Bukkit.getPlayer((String)args[2]);
                if (target != null) {
                    amount = 1;
                } else {
                    if (!(sender instanceof Player)) {
                        Messages.usageMessage(sender);
                        return false;
                    }
                    try {
                        amount = Integer.parseInt(args[2]);
                        target = (Player)sender;
                    }
                    catch (Exception e) {
                        Messages.offlineMessage(sender);
                        return false;
                    }
                }
            } else {
                if (args.length != 4) {
                    Messages.usageMessage(sender);
                    return false;
                }
                target = Bukkit.getPlayer((String)args[2]);
                if (target == null) {
                    Messages.offlineMessage(sender);
                    return false;
                }
                try {
                    amount = Integer.parseInt(args[3]);
                }
                catch (Exception e) {
                    Messages.amountMessage(sender);
                    return false;
                }
            }
            BandageManager.giveBandage(target, type, amount);
            return true;
        }
        if (!args[0].equalsIgnoreCase("giveall")) return false;
        int amount = 0;
        try {
            amount = args.length == 2 ? 1 : Integer.parseInt(args[2]);
        }
        catch (Exception e) {
            Messages.amountMessage(sender);
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            BandageManager.giveBandage(p, type, amount);
        }
        return false;
    }
}

