/*
 * Decompiled with CFR 0.152.
 */
package velariyel.bandages;

import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import velariyel.bandages.PaperHealing;

public class BandageType {
    private static Set<Material> materials = new HashSet<Material>();
    public static Set<BandageType> bandageTypes = new HashSet<BandageType>();
    private String type;
    private String dname;
    private ItemStack bandage;
    private int healing;
    private int regen;
    private long regentime;
    private int amountused;
    private long timetouse;
    private long cooldown;

    private void setDisplayName(String dname) {
        this.dname = dname;
    }

    private void setHealing(int healing) {
        this.healing = healing;
    }

    private void setRegen(int regen) {
        this.regen = regen;
    }

    private void setRegenTime(long regentime) {
        this.regentime = regentime;
    }

    private void setAmountUsed(int amountused) {
        this.amountused = amountused;
    }

    private void setTimeToUse(long timetouse) {
        this.timetouse = timetouse;
    }

    private void setCooldown(long cooldown) {
        this.cooldown = cooldown;
    }

    private void setBandage(ItemStack bandage) {
        this.bandage = bandage;
    }

    public String getDisplayName() {
        return this.dname;
    }

    public int getHealing() {
        return this.healing;
    }

    public int getRegen() {
        return this.regen;
    }

    public long getRegenTime() {
        return this.regentime;
    }

    public int getAmountUsed() {
        return this.amountused;
    }

    public long getTimeToUse() {
        return this.timetouse;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public ItemStack getBandage(int amount) {
        ItemStack item = this.bandage.clone();
        item.setAmount(amount);
        return item;
    }

    public ItemStack getBandage() {
        return this.bandage.clone();
    }

    private void setType(String type) {
        this.type = type.toUpperCase();
    }

    public String getType() {
        return this.type;
    }

    public boolean isType(BandageType btype) {
        return this.isType(btype.getType());
    }

    public boolean isType(String string) {
        return this.type.equals(string);
    }

    public static BandageType getBandageType(String type) {
        for (BandageType t : bandageTypes) {
            if (!t.isType(type.toUpperCase())) continue;
            return t;
        }
        return null;
    }

    public static void loadTypes() {
        ConfigurationSection bandages = PaperHealing.getInstance().getConfig().getConfigurationSection("Bandages");
        for (String name : bandages.getKeys(false)) {
            ConfigurationSection j = bandages.getConfigurationSection(name);
            BandageType btype = new BandageType();
            Material mat = Material.PAPER;
            if (j.contains("Material")) {
                Material m = Material.matchMaterial((String)j.getString("Material"));
                if (m != null) {
                    mat = m;
                } else {
                    PaperHealing.getLog().warning("Could not identify Material type: " + j.getString("Material"));
                }
            }
            materials.add(mat);
            ItemStack bandage = new ItemStack(mat);
            ItemMeta meta = bandage.getItemMeta();
            meta.setDisplayName(ChatColor.RESET + ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(j.getString("DisplayName")) + ChatColor.RESET)));
            ArrayList<String> lore = new ArrayList<String>();
            for (String s : j.getStringList("Lore")) {
                lore.add(ChatColor.RESET + ChatColor.translateAlternateColorCodes((char)'&', (String)s));
            }
            meta.setLore(lore);
            bandage.setItemMeta(meta);
            bandage = NBTEditor.setItemTag(bandage, name, "bandage");
            btype.setType(name.toUpperCase());
            btype.setDisplayName(meta.getDisplayName());
            btype.setHealing(j.getInt("Healing"));
            btype.setRegen(j.getInt("Regen"));
            btype.setRegenTime(j.getLong("RegenTime"));
            btype.setAmountUsed(j.getInt("AmountUsed"));
            btype.setTimeToUse(j.getLong("TimeToUse"));
            btype.setCooldown(j.getLong("Cooldown"));
            btype.setBandage(bandage);
            BandageType.addBandageType(btype);
            PaperHealing.getInstance().getLogger().info("Loaded BandageType: " + name);
        }
    }

    public static void addBandageType(BandageType btype) {
        bandageTypes.add(btype);
    }

    public static boolean isMaterial(Material material) {
        return materials.contains(material);
    }
}

