/*
 * Decompiled with CFR 0.152.
 */
package velariyel.bandages;

import io.github.bananapuncher714.nbteditor.NBTEditor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import velariyel.bandages.BandageType;
import velariyel.bandages.Messages;
import velariyel.bandages.PaperHealing;
import velariyel.bandages.Setting;

public class BandageManager {
    public static void giveBandage(Player player, BandageType type, int amount) {
        player.getInventory().addItem(new ItemStack[]{type.getBandage(amount)});
    }

    public static boolean useBandage(Player player, ItemStack item) {
        String type = (String)NBTEditor.getItemTag(item, "bandage");
        if (type == null) {
            return false;
        }
        BandageType btype = BandageType.getBandageType(type);
        if (btype == null) {
            PaperHealing.getLog().warning(String.valueOf(player.getName()) + " has used an unknown BandageType: " + type);
            if (PaperHealing.getCfgBoolean(Setting.DESTROYOLD)) {
                PaperHealing.getLog().warning(String.valueOf(Setting.DESTROYOLD.getKey()) + ": true - Destroyed!");
                player.setItemInHand(null);
            }
            return false;
        }
        if (player.getHealth() >= player.getMaxHealth()) {
            Messages.fullhealthMessage(player);
            return true;
        }
        if (!BandageManager.hasEnough(player, btype)) {
            Messages.notenoughMessage(player);
            return true;
        }
        if (player.hasMetadata("paperhealing.using")) {
            long t = ((MetadataValue)player.getMetadata("paperhealing.using").get(0)).asLong();
            Messages.alreadyusingMessage(player, t);
            return true;
        }
        if (player.hasMetadata("paperhealing.cooldown")) {
            long t = ((MetadataValue)player.getMetadata("paperhealing.cooldown").get(0)).asLong();
            Messages.cooldownMessage(player, t);
            return true;
        }
        Messages.startusingMessage(player, btype);
        BandageManager.removeBandages(player, btype);
        BandageManager.applyEffects(player, btype);
        return true;
    }

    public static boolean hasEnough(Player player, BandageType type) {
        int count = 0;
        ItemStack[] itemStackArray = player.getInventory().getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                block7: {
                    ItemStack i = itemStackArray[n2];
                    if (i == null || i.getType() == Material.AIR) break block6;
                    if (!BandageType.isMaterial(i.getType())) break block7;
                    String nbt = (String)NBTEditor.getItemTag(i, "bandage");
                    if (nbt == null) break block6;
                    if (BandageType.getBandageType(nbt).isType(type)) {
                        count += i.getAmount();
                    }
                }
                if (count >= type.getAmountUsed()) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static void removeBandages(Player player, BandageType type) {
        int toremove = type.getAmountUsed();
        PlayerInventory inv = player.getInventory();
        ItemStack[] itemStackArray = inv.getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                block10: {
                    ItemStack i = itemStackArray[n2];
                    if (i == null || i.getType() == Material.AIR) break block9;
                    if (!BandageType.isMaterial(i.getType())) break block10;
                    String nbt = (String)NBTEditor.getItemTag(i, "bandage");
                    if (nbt == null) break block9;
                    if (BandageType.getBandageType(nbt).isType(type)) {
                        if (i.getAmount() <= toremove) {
                            toremove -= i.getAmount();
                            inv.removeItem(new ItemStack[]{i});
                        } else if (i.getAmount() >= toremove) {
                            i.setAmount(i.getAmount() - toremove);
                            toremove = 0;
                        }
                    }
                }
                if (toremove == 0) {
                    player.updateInventory();
                    return;
                }
            }
            ++n2;
        }
    }

    public static void applyCooldown(final Player player, BandageType type) {
        if (type.getCooldown() > 0L) {
            player.setMetadata("paperhealing.cooldown", (MetadataValue)new FixedMetadataValue((Plugin)PaperHealing.getInstance(), (Object)(System.currentTimeMillis() + type.getCooldown() * 50L)));
            new BukkitRunnable(){

                public void run() {
                    player.removeMetadata("paperhealing.cooldown", (Plugin)PaperHealing.getInstance());
                }
            }.runTaskLater((Plugin)PaperHealing.getInstance(), type.getCooldown());
        }
    }

    public static void applyEffects(Player player, BandageType type) {
        BandageManager.applyEffects(player, type, false);
    }

    public static void applyEffects(final Player player, final BandageType type, boolean instant) {
        if (!instant) {
            player.setMetadata("paperhealing.using", (MetadataValue)new FixedMetadataValue((Plugin)PaperHealing.getInstance(), (Object)(System.currentTimeMillis() + type.getTimeToUse() * 50L)));
        }
        new BukkitRunnable(){

            public void run() {
                if (player.hasMetadata("paperhealing.using")) {
                    player.removeMetadata("paperhealing.using", (Plugin)PaperHealing.getInstance());
                    Messages.finishedusingMessage(player, type.getHealing());
                } else {
                    Messages.effectgivenMessage(player, type);
                }
                BandageManager.applyCooldown(player, type);
                player.setHealth(Double.min(player.getHealth() + (double)type.getHealing(), player.getMaxHealth()));
                if (type.getRegen() > 0 && type.getRegenTime() > 0L) {
                    long halftime = Math.round(type.getRegenTime() / (long)type.getRegen());
                    new BukkitRunnable(){
                        int healed = 0;

                        public void run() {
                            if (this.healed >= type.getRegen()) {
                                this.cancel();
                                return;
                            }
                            ++this.healed;
                            player.setHealth(Double.min(player.getHealth() + 1.0, player.getMaxHealth()));
                        }
                    }.runTaskTimer((Plugin)PaperHealing.getInstance(), halftime, halftime);
                }
            }
        }.runTaskLater((Plugin)PaperHealing.getInstance(), instant ? 1L : type.getTimeToUse());
    }
}

