/*
 * Decompiled with CFR 0.152.
 */
package io.github.bananapuncher714.nbteditor;

import com.google.common.primitives.Primitives;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class NBTEditor {
    private static HashMap<String, Class<?>> classCache;
    private static HashMap<String, Method> methodCache;
    private static HashMap<Class<?>, Constructor<?>> constructorCache;
    private static HashMap<Class<?>, Class<?>> NBTClasses;
    private static HashMap<Class<?>, Field> NBTTagFieldCache;
    private static Field NBTListData;
    private static Field NBTCompoundMap;
    private static String version;

    static {
        version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        classCache = new HashMap();
        try {
            classCache.put("NBTBase", Class.forName("net.minecraft.server." + version + "." + "NBTBase"));
            classCache.put("NBTTagCompound", Class.forName("net.minecraft.server." + version + "." + "NBTTagCompound"));
            classCache.put("NBTTagList", Class.forName("net.minecraft.server." + version + "." + "NBTTagList"));
            classCache.put("NBTBase", Class.forName("net.minecraft.server." + version + "." + "NBTBase"));
            classCache.put("ItemStack", Class.forName("net.minecraft.server." + version + "." + "ItemStack"));
            classCache.put("CraftItemStack", Class.forName("org.bukkit.craftbukkit." + version + ".inventory." + "CraftItemStack"));
            classCache.put("Entity", Class.forName("net.minecraft.server." + version + "." + "Entity"));
            classCache.put("CraftEntity", Class.forName("org.bukkit.craftbukkit." + version + ".entity." + "CraftEntity"));
            classCache.put("EntityLiving", Class.forName("net.minecraft.server." + version + "." + "EntityLiving"));
            classCache.put("CraftWorld", Class.forName("org.bukkit.craftbukkit." + version + "." + "CraftWorld"));
            classCache.put("CraftBlockState", Class.forName("org.bukkit.craftbukkit." + version + ".block." + "CraftBlockState"));
            classCache.put("BlockPosition", Class.forName("net.minecraft.server." + version + "." + "BlockPosition"));
            classCache.put("TileEntity", Class.forName("net.minecraft.server." + version + "." + "TileEntity"));
            classCache.put("World", Class.forName("net.minecraft.server." + version + "." + "World"));
            classCache.put("TileEntitySkull", Class.forName("net.minecraft.server." + version + "." + "TileEntitySkull"));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        NBTClasses = new HashMap();
        try {
            NBTClasses.put(Byte.class, Class.forName("net.minecraft.server." + version + "." + "NBTTagByte"));
            NBTClasses.put(String.class, Class.forName("net.minecraft.server." + version + "." + "NBTTagString"));
            NBTClasses.put(Double.class, Class.forName("net.minecraft.server." + version + "." + "NBTTagDouble"));
            NBTClasses.put(Integer.class, Class.forName("net.minecraft.server." + version + "." + "NBTTagInt"));
            NBTClasses.put(Long.class, Class.forName("net.minecraft.server." + version + "." + "NBTTagLong"));
            NBTClasses.put(Short.class, Class.forName("net.minecraft.server." + version + "." + "NBTTagShort"));
            NBTClasses.put(Float.class, Class.forName("net.minecraft.server." + version + "." + "NBTTagFloat"));
            NBTClasses.put(Class.forName("[B"), Class.forName("net.minecraft.server." + version + "." + "NBTTagByteArray"));
            NBTClasses.put(Class.forName("[I"), Class.forName("net.minecraft.server." + version + "." + "NBTTagIntArray"));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        methodCache = new HashMap();
        try {
            methodCache.put("get", NBTEditor.getNMSClass("NBTTagCompound").getMethod("get", String.class));
            methodCache.put("set", NBTEditor.getNMSClass("NBTTagCompound").getMethod("set", String.class, NBTEditor.getNMSClass("NBTBase")));
            methodCache.put("hasKey", NBTEditor.getNMSClass("NBTTagCompound").getMethod("hasKey", String.class));
            methodCache.put("setIndex", NBTEditor.getNMSClass("NBTTagList").getMethod("a", Integer.TYPE, NBTEditor.getNMSClass("NBTBase")));
            methodCache.put("add", NBTEditor.getNMSClass("NBTTagList").getMethod("add", NBTEditor.getNMSClass("NBTBase")));
            methodCache.put("hasTag", NBTEditor.getNMSClass("ItemStack").getMethod("hasTag", new Class[0]));
            methodCache.put("getTag", NBTEditor.getNMSClass("ItemStack").getMethod("getTag", new Class[0]));
            methodCache.put("setTag", NBTEditor.getNMSClass("ItemStack").getMethod("setTag", NBTEditor.getNMSClass("NBTTagCompound")));
            methodCache.put("asNMSCopy", NBTEditor.getNMSClass("CraftItemStack").getMethod("asNMSCopy", ItemStack.class));
            methodCache.put("asBukkitCopy", NBTEditor.getNMSClass("CraftItemStack").getMethod("asBukkitCopy", NBTEditor.getNMSClass("ItemStack")));
            methodCache.put("getEntityHandle", NBTEditor.getNMSClass("CraftEntity").getMethod("getHandle", new Class[0]));
            methodCache.put("getEntityTag", NBTEditor.getNMSClass("Entity").getMethod("c", NBTEditor.getNMSClass("NBTTagCompound")));
            methodCache.put("setEntityTag", NBTEditor.getNMSClass("Entity").getMethod("f", NBTEditor.getNMSClass("NBTTagCompound")));
            if (version.contains("1_12")) {
                methodCache.put("setTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("load", NBTEditor.getNMSClass("NBTTagCompound")));
            } else {
                methodCache.put("setTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("a", NBTEditor.getNMSClass("NBTTagCompound")));
            }
            methodCache.put("getTileEntity", NBTEditor.getNMSClass("World").getMethod("getTileEntity", NBTEditor.getNMSClass("BlockPosition")));
            methodCache.put("getWorldHandle", NBTEditor.getNMSClass("CraftWorld").getMethod("getHandle", new Class[0]));
            methodCache.put("setGameProfile", NBTEditor.getNMSClass("TileEntitySkull").getMethod("setGameProfile", GameProfile.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            methodCache.put("getTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("save", NBTEditor.getNMSClass("NBTTagCompound")));
        }
        catch (NoSuchMethodException exception) {
            try {
                methodCache.put("getTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("b", NBTEditor.getNMSClass("NBTTagCompound")));
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        constructorCache = new HashMap();
        try {
            constructorCache.put(NBTEditor.getNBTTag(Byte.class), NBTEditor.getNBTTag(Byte.class).getConstructor(Byte.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(String.class), NBTEditor.getNBTTag(String.class).getConstructor(String.class));
            constructorCache.put(NBTEditor.getNBTTag(Double.class), NBTEditor.getNBTTag(Double.class).getConstructor(Double.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Integer.class), NBTEditor.getNBTTag(Integer.class).getConstructor(Integer.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Long.class), NBTEditor.getNBTTag(Long.class).getConstructor(Long.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Float.class), NBTEditor.getNBTTag(Float.class).getConstructor(Float.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Short.class), NBTEditor.getNBTTag(Short.class).getConstructor(Short.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Class.forName("[B")), NBTEditor.getNBTTag(Class.forName("[B")).getConstructor(Class.forName("[B")));
            constructorCache.put(NBTEditor.getNBTTag(Class.forName("[I")), NBTEditor.getNBTTag(Class.forName("[I")).getConstructor(Class.forName("[I")));
            constructorCache.put(NBTEditor.getNMSClass("BlockPosition"), NBTEditor.getNMSClass("BlockPosition").getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NBTTagFieldCache = new HashMap();
        try {
            for (Class<?> clazz : NBTClasses.values()) {
                Field data = clazz.getDeclaredField("data");
                data.setAccessible(true);
                NBTTagFieldCache.put(clazz, data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            NBTListData = NBTEditor.getNMSClass("NBTTagList").getDeclaredField("list");
            NBTListData.setAccessible(true);
            NBTCompoundMap = NBTEditor.getNMSClass("NBTTagCompound").getDeclaredField("map");
            NBTCompoundMap.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Class<?> getPrimitiveClass(Class<?> clazz) {
        return Primitives.unwrap(clazz);
    }

    public static Class<?> getNBTTag(Class<?> primitiveType) {
        if (NBTClasses.containsKey(primitiveType)) {
            return NBTClasses.get(primitiveType);
        }
        return primitiveType;
    }

    public static Object getNBTVar(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        try {
            if (NBTTagFieldCache.containsKey(clazz)) {
                return NBTTagFieldCache.get(clazz).get(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static Method getMethod(String name) {
        return methodCache.containsKey(name) ? methodCache.get(name) : null;
    }

    public static Constructor<?> getConstructor(Class<?> clazz) {
        return constructorCache.containsKey(clazz) ? constructorCache.get(clazz) : null;
    }

    public static Class<?> getNMSClass(String name) {
        if (classCache.containsKey(name)) {
            return classCache.get(name);
        }
        try {
            return Class.forName("net.minecraft.server." + version + "." + name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMatch(String string, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static final ItemStack getHead(String skinURL) {
        ItemStack head = new ItemStack(Material.SKULL_ITEM, 1, 3);
        if (skinURL == null || skinURL.isEmpty()) {
            return head;
        }
        ItemMeta headMeta = head.getItemMeta();
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        byte[] encodedData = Base64.encodeBase64((byte[])String.format("{textures:{SKIN:{\"url\":\"%s\"}}}", skinURL).getBytes());
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", new String(encodedData)));
        Field profileField = null;
        try {
            profileField = headMeta.getClass().getDeclaredField("profile");
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        profileField.setAccessible(true);
        try {
            profileField.set(headMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        head.setItemMeta(headMeta);
        return head;
    }

    public static final String getTexture(ItemStack head) {
        GameProfile profile;
        block6: {
            ItemMeta meta = head.getItemMeta();
            Field profileField = null;
            try {
                profileField = meta.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            profileField.setAccessible(true);
            profile = (GameProfile)profileField.get(meta);
            if (profile != null) break block6;
            return null;
        }
        try {
            for (Property prop : profile.getProperties().values()) {
                if (!prop.getName().equals("textures")) continue;
                String texture = new String(Base64.decodeBase64((String)prop.getValue()));
                return NBTEditor.getMatch(texture, "\\{\"url\":\"(.*?)\"\\}");
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getItemTag(ItemStack item, Object ... keys) {
        try {
            Object stack = null;
            stack = NBTEditor.getMethod("asNMSCopy").invoke(null, item);
            Object tag = null;
            tag = NBTEditor.getMethod("hasTag").invoke(stack, new Object[0]).equals(true) ? NBTEditor.getMethod("getTag").invoke(stack, new Object[0]) : (Object)NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            return NBTEditor.getTag(tag, keys);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static ItemStack setItemTag(ItemStack item, Object value, Object ... keys) {
        try {
            Object stack = NBTEditor.getMethod("asNMSCopy").invoke(null, item);
            Object tag = null;
            tag = NBTEditor.getMethod("hasTag").invoke(stack, new Object[0]).equals(true) ? NBTEditor.getMethod("getTag").invoke(stack, new Object[0]) : (Object)NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.setTag(tag, value, keys);
            NBTEditor.getMethod("setTag").invoke(stack, tag);
            return (ItemStack)NBTEditor.getMethod("asBukkitCopy").invoke(null, stack);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Object getEntityTag(Entity entity, Object ... keys) {
        try {
            Object NMSEntity = NBTEditor.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object tag = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getEntityTag").invoke(NMSEntity, tag);
            return NBTEditor.getTag(tag, keys);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void setEntityTag(Entity entity, Object value, Object ... keys) {
        try {
            Object NMSEntity = NBTEditor.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object tag = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getEntityTag").invoke(NMSEntity, tag);
            NBTEditor.setTag(tag, value, keys);
            NBTEditor.getMethod("setEntityTag").invoke(NMSEntity, tag);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static Object getBlockTag(Block block, Object ... keys) {
        block3: {
            try {
                if (NBTEditor.getNMSClass("CraftBlockState").isInstance(block.getState())) break block3;
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        Object tileEntity = NBTEditor.getMethod("getTileEntity").invoke((Object)block.getState(), new Object[0]);
        Object tag = NBTEditor.getMethod("getTileTag").invoke(tileEntity, NBTEditor.getNMSClass("NBTTagCompound").newInstance());
        return NBTEditor.getTag(tag, keys);
    }

    public static void setBlockTag(Block block, Object value, Object ... keys) {
        try {
            Location location = block.getLocation();
            Object blockPosition = NBTEditor.getConstructor(NBTEditor.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = NBTEditor.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = NBTEditor.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
            Object tag = NBTEditor.getMethod("getTileTag").invoke(tileEntity, NBTEditor.getNMSClass("NBTTagCompound").newInstance());
            NBTEditor.setTag(tag, value, keys);
            NBTEditor.getMethod("setTileTag").invoke(tileEntity, tag);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void setSkullTexture(Block block, String texture) {
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", new String(Base64.encodeBase64((byte[])String.format("{textures:{SKIN:{\"url\":\"%s\"}}}", texture).getBytes()))));
        try {
            Location location = block.getLocation();
            Object blockPosition = NBTEditor.getConstructor(NBTEditor.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = NBTEditor.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = NBTEditor.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
            NBTEditor.getMethod("setGameProfile").invoke(tileEntity, profile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void setTag(Object tag, Object value, Object ... keys) throws Exception {
        Object notCompound = NBTEditor.getConstructor(NBTEditor.getNBTTag(value.getClass())).newInstance(value);
        Object compound = tag;
        int index = 0;
        while (index < keys.length) {
            Object key = keys[index];
            if (index + 1 == keys.length) {
                if (key == null) {
                    NBTEditor.getMethod("add").invoke(compound, notCompound);
                    break;
                }
                if (key instanceof Integer) {
                    NBTEditor.getMethod("setIndex").invoke(compound, (int)((Integer)key), notCompound);
                    break;
                }
                NBTEditor.getMethod("set").invoke(compound, (String)key, notCompound);
                break;
            }
            Object oldCompound = compound;
            if (key instanceof Integer) {
                compound = ((List)NBTListData.get(compound)).get((Integer)key);
            } else if (key != null) {
                compound = NBTEditor.getMethod("get").invoke(compound, (String)key);
            }
            if (compound == null || key == null) {
                compound = keys[index + 1] == null || keys[index + 1] instanceof Integer ? NBTEditor.getNMSClass("NBTTagList").newInstance() : NBTEditor.getNMSClass("NBTTagCompound").newInstance();
                if (oldCompound.getClass().getSimpleName().equals("NBTTagList")) {
                    NBTEditor.getMethod("add").invoke(oldCompound, compound);
                } else {
                    NBTEditor.getMethod("set").invoke(oldCompound, (String)key, compound);
                }
            }
            ++index;
        }
    }

    private static Object getTag(Object tag, Object ... keys) throws Exception {
        if (keys.length == 0) {
            return NBTEditor.getTags(tag);
        }
        Object notCompound = tag;
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            if (notCompound == null) {
                return null;
            }
            if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(notCompound)) {
                notCompound = NBTEditor.getMethod("get").invoke(notCompound, (String)key);
            } else if (NBTEditor.getNMSClass("NBTTagList").isInstance(notCompound)) {
                notCompound = ((List)NBTListData.get(notCompound)).get((Integer)key);
            } else {
                return NBTEditor.getNBTVar(notCompound);
            }
            ++n2;
        }
        if (notCompound == null) {
            return null;
        }
        if (NBTEditor.getNMSClass("NBTTagList").isInstance(notCompound)) {
            return NBTEditor.getTags(notCompound);
        }
        if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(notCompound)) {
            return NBTEditor.getTags(notCompound);
        }
        return NBTEditor.getNBTVar(notCompound);
    }

    private static Object getTags(Object tag) {
        HashMap<Object, Object> tags = new HashMap<Object, Object>();
        try {
            if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(tag)) {
                Map tagCompound = (Map)NBTCompoundMap.get(tag);
                for (String key : tagCompound.keySet()) {
                    Object value = tagCompound.get(key);
                    if (NBTEditor.getNMSClass("NBTTagEnd").isInstance(value)) continue;
                    tags.put(key, NBTEditor.getTag(value, new Object[0]));
                }
            } else if (NBTEditor.getNMSClass("NBTTagList").isInstance(tag)) {
                List tagList = (List)NBTListData.get(tag);
                int index = 0;
                while (index < tagList.size()) {
                    Object value = tagList.get(index);
                    if (!NBTEditor.getNMSClass("NBTTagEnd").isInstance(value)) {
                        tags.put(index, NBTEditor.getTag(value, new Object[0]));
                    }
                    ++index;
                }
            } else {
                return NBTEditor.getNBTVar(tag);
            }
            return tags;
        }
        catch (Exception e) {
            e.printStackTrace();
            return tags;
        }
    }
}

