/*
 * Decompiled with CFR 0.152.
 */
package com.demkom58.packetsbookfix;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.demkom58.packetsbookfix.Data;
import org.bukkit.BanList;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PacketsBookFix
extends JavaPlugin
implements Listener {
    private static PacketsBookFix instance;

    public void onEnable() {
        instance = this;
        this.initialize();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)PacketsBookFix.getInstance(), ListenerPriority.LOWEST, new PacketType[]{PacketType.Play.Client.CUSTOM_PAYLOAD}){

            public void onPacketReceiving(PacketEvent event) {
                if (event.getPlayer() == null) {
                    return;
                }
                PacketContainer packet = event.getPacket();
                String channelName = (String)packet.getStrings().readSafely(0);
                if ("MC|BEdit".equals(channelName) || "MC|BSign".equals(channelName)) {
                    if (event.getPlayer().isBanned()) {
                        event.setCancelled(true);
                        return;
                    }
                    PacketsBookFix.this.safePacket(event);
                }
            }
        });
    }

    private void initialize() {
        this.saveDefaultConfig();
        this.reloadConfig();
        Data.packetInMillis = this.getConfig().getInt("packetInMillis");
        Data.action = this.getConfig().getString("action").toLowerCase();
        Data.reloadPermission = this.getConfig().getString("reloadPermission");
        Data.kickMessage = this.getConfig().getString("kickMessage").replaceAll("&", "\u00a7").replaceAll("%newline%", "\n");
        Data.banMessage = this.getConfig().getString("banMessage").replaceAll("&", "\u00a7").replaceAll("%newline%", "\n");
        Data.reloadedMessage = this.getConfig().getString("reloadedMessage").replaceAll("&", "\u00a7").replaceAll("%newline%", "\n");
    }

    private void safePacket(PacketEvent event) {
        Player p = event.getPlayer();
        if (this.check(p)) {
            return;
        }
        event.setCancelled(true);
        this.punish(p);
    }

    private void punish(Player p) {
        if (!p.isOnline()) {
            return;
        }
        if ("ban".equals(Data.action)) {
            this.getServer().getBanList(BanList.Type.IP).addBan(p.getAddress().getHostName(), Data.banMessage, null, "PacketsBookFix");
            this.getServer().getBanList(BanList.Type.NAME).addBan(p.getName(), Data.banMessage, null, "PacketsBookFix");
        }
        this.getServer().getScheduler().runTask((Plugin)this, () -> {
            if (p.isOnline()) {
                p.kickPlayer(Data.kickMessage);
            }
        });
    }

    private boolean check(Player p) {
        if (!p.isOnline()) {
            Data.usedBooksMap.remove(p);
            return true;
        }
        if (!Data.usedBooksMap.containsKey(p)) {
            Data.usedBooksMap.put(p, System.currentTimeMillis() + (long)Data.packetInMillis);
            return true;
        }
        if (Data.usedBooksMap.get(p) < System.currentTimeMillis()) {
            Data.usedBooksMap.put(p, System.currentTimeMillis() + (long)Data.packetInMillis);
            return true;
        }
        return false;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 1 && sender.hasPermission(Data.reloadPermission) && args[0].equalsIgnoreCase("reload")) {
            this.initialize();
            sender.sendMessage(Data.reloadedMessage);
            return true;
        }
        sender.sendMessage("&aPacketBookFix 1.5 &7| &cCreated by demkom58.".replaceAll("&", "\u00a7"));
        return false;
    }

    private static PacketsBookFix getInstance() {
        return instance;
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent quitEvent) {
        Data.usedBooksMap.remove(quitEvent.getPlayer());
    }
}

