/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.pfs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionNumber
implements Comparable<VersionNumber> {
    private static final Pattern MATCH_NUMBERS = Pattern.compile("([0-9][0-9]*)");
    private final String version;
    private final List<Long> versionNumbers;

    public VersionNumber(String version) {
        this.version = version;
        Matcher matches = MATCH_NUMBERS.matcher(version);
        this.versionNumbers = new ArrayList<Long>();
        while (matches.find()) {
            this.versionNumbers.add(Long.parseLong(matches.group()));
        }
    }

    public boolean isNewerThan(VersionNumber other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionNumber that = (VersionNumber)o;
        return this.version.equals(that.version);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    @Override
    public int compareTo(VersionNumber o) {
        int vSize = this.versionNumbers.size();
        int ovSize = o.versionNumbers.size();
        for (int i = 0; i < Math.min(vSize, ovSize); ++i) {
            int comparison = o.versionNumbers.get(i).compareTo(this.versionNumbers.get(i));
            if (comparison == 0) continue;
            return comparison;
        }
        if (vSize == ovSize || vSize != 0 && ovSize != 0) {
            return 0;
        }
        return vSize > ovSize ? -1 : 1;
    }

    public String asString() {
        return this.version;
    }

    public String toString() {
        return "VersionNumber{version='" + this.version + '\'' + '}';
    }
}

